/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.admin;

import com.microsoft.graph.admin.edge.EdgeRequestBuilder;
import com.microsoft.graph.admin.microsoft365apps.Microsoft365AppsRequestBuilder;
import com.microsoft.graph.admin.people.PeopleRequestBuilder;
import com.microsoft.graph.admin.serviceannouncement.ServiceAnnouncementRequestBuilder;
import com.microsoft.graph.admin.sharepoint.SharepointRequestBuilder;
import com.microsoft.graph.models.Admin;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AdminRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public EdgeRequestBuilder edge() {
        return new EdgeRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public Microsoft365AppsRequestBuilder microsoft365Apps() {
        return new Microsoft365AppsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PeopleRequestBuilder people() {
        return new PeopleRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ServiceAnnouncementRequestBuilder serviceAnnouncement() {
        return new ServiceAnnouncementRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SharepointRequestBuilder sharepoint() {
        return new SharepointRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public AdminRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/admin{?%24expand,%24select}", pathParameters);
    }

    public AdminRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/admin{?%24expand,%24select}", rawUrl);
    }

    @Nullable
    public Admin get() {
        return this.get(null);
    }

    @Nullable
    public Admin get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Admin)this.requestAdapter.send(requestInfo, errorMapping, Admin::createFromDiscriminatorValue);
    }

    @Nullable
    public Admin patch(@Nonnull Admin body) {
        return this.patch(body, null);
    }

    @Nullable
    public Admin patch(@Nonnull Admin body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Admin)this.requestAdapter.send(requestInfo, errorMapping, Admin::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Admin body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Admin body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public AdminRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new AdminRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

