/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.teamwork;

import com.microsoft.graph.models.Teamwork;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.teamwork.deletedteams.DeletedTeamsRequestBuilder;
import com.microsoft.graph.teamwork.sendactivitynotificationtorecipients.SendActivityNotificationToRecipientsRequestBuilder;
import com.microsoft.graph.teamwork.teamsappsettings.TeamsAppSettingsRequestBuilder;
import com.microsoft.graph.teamwork.workforceintegrations.WorkforceIntegrationsRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TeamworkRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public DeletedTeamsRequestBuilder deletedTeams() {
        return new DeletedTeamsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SendActivityNotificationToRecipientsRequestBuilder sendActivityNotificationToRecipients() {
        return new SendActivityNotificationToRecipientsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TeamsAppSettingsRequestBuilder teamsAppSettings() {
        return new TeamsAppSettingsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public WorkforceIntegrationsRequestBuilder workforceIntegrations() {
        return new WorkforceIntegrationsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public TeamworkRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/teamwork{?%24expand,%24select}", pathParameters);
    }

    public TeamworkRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/teamwork{?%24expand,%24select}", rawUrl);
    }

    @Nullable
    public Teamwork get() {
        return this.get(null);
    }

    @Nullable
    public Teamwork get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (Teamwork)this.requestAdapter.send(requestInfo, errorMapping, Teamwork::createFromDiscriminatorValue);
    }

    @Nullable
    public Teamwork patch(@Nonnull Teamwork body) {
        return this.patch(body, null);
    }

    @Nullable
    public Teamwork patch(@Nonnull Teamwork body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (Teamwork)this.requestAdapter.send(requestInfo, errorMapping, Teamwork::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Teamwork body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Teamwork body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public TeamworkRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new TeamworkRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

