/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DayOfWeek;
import com.microsoft.graph.models.DaylightTimeZoneOffset;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class StandardTimeZoneOffset
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public StandardTimeZoneOffset() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static StandardTimeZoneOffset createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.daylightTimeZoneOffset": {
                    return new DaylightTimeZoneOffset();
                }
            }
        }
        return new StandardTimeZoneOffset();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getDayOccurrence() {
        return (Integer)this.backingStore.get("dayOccurrence");
    }

    @Nullable
    public DayOfWeek getDayOfWeek() {
        return (DayOfWeek)((Object)this.backingStore.get("dayOfWeek"));
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("dayOccurrence", n -> this.setDayOccurrence(n.getIntegerValue()));
        deserializerMap.put("dayOfWeek", n -> this.setDayOfWeek((DayOfWeek)n.getEnumValue(DayOfWeek::forValue)));
        deserializerMap.put("month", n -> this.setMonth(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("time", n -> this.setTime(n.getLocalTimeValue()));
        deserializerMap.put("year", n -> this.setYear(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public Integer getMonth() {
        return (Integer)this.backingStore.get("month");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public LocalTime getTime() {
        return (LocalTime)this.backingStore.get("time");
    }

    @Nullable
    public Integer getYear() {
        return (Integer)this.backingStore.get("year");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("dayOccurrence", this.getDayOccurrence());
        writer.writeEnumValue("dayOfWeek", (Enum)this.getDayOfWeek());
        writer.writeIntegerValue("month", this.getMonth());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeLocalTimeValue("time", this.getTime());
        writer.writeIntegerValue("year", this.getYear());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDayOccurrence(@Nullable Integer value) {
        this.backingStore.set("dayOccurrence", (Object)value);
    }

    public void setDayOfWeek(@Nullable DayOfWeek value) {
        this.backingStore.set("dayOfWeek", (Object)value);
    }

    public void setMonth(@Nullable Integer value) {
        this.backingStore.set("month", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setTime(@Nullable LocalTime value) {
        this.backingStore.set("time", (Object)value);
    }

    public void setYear(@Nullable Integer value) {
        this.backingStore.set("year", (Object)value);
    }
}

