/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DeviceAndAppManagementRoleDefinition;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.RoleAssignment;
import com.microsoft.graph.models.RolePermission;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RoleDefinition
extends Entity
implements Parsable {
    @Nonnull
    public static RoleDefinition createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.deviceAndAppManagementRoleDefinition": {
                    return new DeviceAndAppManagementRoleDefinition();
                }
            }
        }
        return new RoleDefinition();
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("isBuiltIn", n -> this.setIsBuiltIn(n.getBooleanValue()));
        deserializerMap.put("roleAssignments", n -> this.setRoleAssignments(n.getCollectionOfObjectValues(RoleAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("rolePermissions", n -> this.setRolePermissions(n.getCollectionOfObjectValues(RolePermission::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsBuiltIn() {
        return (Boolean)this.backingStore.get("isBuiltIn");
    }

    @Nullable
    public List<RoleAssignment> getRoleAssignments() {
        return (List)this.backingStore.get("roleAssignments");
    }

    @Nullable
    public List<RolePermission> getRolePermissions() {
        return (List)this.backingStore.get("rolePermissions");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeBooleanValue("isBuiltIn", this.getIsBuiltIn());
        writer.writeCollectionOfObjectValues("roleAssignments", this.getRoleAssignments());
        writer.writeCollectionOfObjectValues("rolePermissions", this.getRolePermissions());
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setIsBuiltIn(@Nullable Boolean value) {
        this.backingStore.set("isBuiltIn", (Object)value);
    }

    public void setRoleAssignments(@Nullable List<RoleAssignment> value) {
        this.backingStore.set("roleAssignments", value);
    }

    public void setRolePermissions(@Nullable List<RolePermission> value) {
        this.backingStore.set("rolePermissions", value);
    }
}

