/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AppRoleAssignment;
import com.microsoft.graph.models.AssignedLabel;
import com.microsoft.graph.models.AssignedLicense;
import com.microsoft.graph.models.Calendar;
import com.microsoft.graph.models.Conversation;
import com.microsoft.graph.models.ConversationThread;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.Extension;
import com.microsoft.graph.models.GroupLifecyclePolicy;
import com.microsoft.graph.models.GroupSetting;
import com.microsoft.graph.models.LicenseProcessingState;
import com.microsoft.graph.models.OnPremisesProvisioningError;
import com.microsoft.graph.models.Onenote;
import com.microsoft.graph.models.PlannerGroup;
import com.microsoft.graph.models.ProfilePhoto;
import com.microsoft.graph.models.ResourceSpecificPermissionGrant;
import com.microsoft.graph.models.ServiceProvisioningError;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.models.Team;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Group
extends DirectoryObject
implements Parsable {
    public Group() {
        this.setOdataType("#microsoft.graph.group");
    }

    @Nonnull
    public static Group createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Group();
    }

    @Nullable
    public List<DirectoryObject> getAcceptedSenders() {
        return (List)this.backingStore.get("acceptedSenders");
    }

    @Nullable
    public Boolean getAllowExternalSenders() {
        return (Boolean)this.backingStore.get("allowExternalSenders");
    }

    @Nullable
    public List<AppRoleAssignment> getAppRoleAssignments() {
        return (List)this.backingStore.get("appRoleAssignments");
    }

    @Nullable
    public List<AssignedLabel> getAssignedLabels() {
        return (List)this.backingStore.get("assignedLabels");
    }

    @Nullable
    public List<AssignedLicense> getAssignedLicenses() {
        return (List)this.backingStore.get("assignedLicenses");
    }

    @Nullable
    public Boolean getAutoSubscribeNewMembers() {
        return (Boolean)this.backingStore.get("autoSubscribeNewMembers");
    }

    @Nullable
    public Calendar getCalendar() {
        return (Calendar)this.backingStore.get("calendar");
    }

    @Nullable
    public List<Event> getCalendarView() {
        return (List)this.backingStore.get("calendarView");
    }

    @Nullable
    public String getClassification() {
        return (String)this.backingStore.get("classification");
    }

    @Nullable
    public List<Conversation> getConversations() {
        return (List)this.backingStore.get("conversations");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public DirectoryObject getCreatedOnBehalfOf() {
        return (DirectoryObject)this.backingStore.get("createdOnBehalfOf");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public Drive getDrive() {
        return (Drive)this.backingStore.get("drive");
    }

    @Nullable
    public List<Drive> getDrives() {
        return (List)this.backingStore.get("drives");
    }

    @Nullable
    public List<Event> getEvents() {
        return (List)this.backingStore.get("events");
    }

    @Nullable
    public OffsetDateTime getExpirationDateTime() {
        return (OffsetDateTime)this.backingStore.get("expirationDateTime");
    }

    @Nullable
    public List<Extension> getExtensions() {
        return (List)this.backingStore.get("extensions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("acceptedSenders", n -> this.setAcceptedSenders(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("allowExternalSenders", n -> this.setAllowExternalSenders(n.getBooleanValue()));
        deserializerMap.put("appRoleAssignments", n -> this.setAppRoleAssignments(n.getCollectionOfObjectValues(AppRoleAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("assignedLabels", n -> this.setAssignedLabels(n.getCollectionOfObjectValues(AssignedLabel::createFromDiscriminatorValue)));
        deserializerMap.put("assignedLicenses", n -> this.setAssignedLicenses(n.getCollectionOfObjectValues(AssignedLicense::createFromDiscriminatorValue)));
        deserializerMap.put("autoSubscribeNewMembers", n -> this.setAutoSubscribeNewMembers(n.getBooleanValue()));
        deserializerMap.put("calendar", n -> this.setCalendar((Calendar)n.getObjectValue(Calendar::createFromDiscriminatorValue)));
        deserializerMap.put("calendarView", n -> this.setCalendarView(n.getCollectionOfObjectValues(Event::createFromDiscriminatorValue)));
        deserializerMap.put("classification", n -> this.setClassification(n.getStringValue()));
        deserializerMap.put("conversations", n -> this.setConversations(n.getCollectionOfObjectValues(Conversation::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("createdOnBehalfOf", n -> this.setCreatedOnBehalfOf((DirectoryObject)n.getObjectValue(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("drive", n -> this.setDrive((Drive)n.getObjectValue(Drive::createFromDiscriminatorValue)));
        deserializerMap.put("drives", n -> this.setDrives(n.getCollectionOfObjectValues(Drive::createFromDiscriminatorValue)));
        deserializerMap.put("events", n -> this.setEvents(n.getCollectionOfObjectValues(Event::createFromDiscriminatorValue)));
        deserializerMap.put("expirationDateTime", n -> this.setExpirationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("extensions", n -> this.setExtensions(n.getCollectionOfObjectValues(Extension::createFromDiscriminatorValue)));
        deserializerMap.put("groupLifecyclePolicies", n -> this.setGroupLifecyclePolicies(n.getCollectionOfObjectValues(GroupLifecyclePolicy::createFromDiscriminatorValue)));
        deserializerMap.put("groupTypes", n -> this.setGroupTypes(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("hasMembersWithLicenseErrors", n -> this.setHasMembersWithLicenseErrors(n.getBooleanValue()));
        deserializerMap.put("hideFromAddressLists", n -> this.setHideFromAddressLists(n.getBooleanValue()));
        deserializerMap.put("hideFromOutlookClients", n -> this.setHideFromOutlookClients(n.getBooleanValue()));
        deserializerMap.put("isArchived", n -> this.setIsArchived(n.getBooleanValue()));
        deserializerMap.put("isAssignableToRole", n -> this.setIsAssignableToRole(n.getBooleanValue()));
        deserializerMap.put("isSubscribedByMail", n -> this.setIsSubscribedByMail(n.getBooleanValue()));
        deserializerMap.put("licenseProcessingState", n -> this.setLicenseProcessingState((LicenseProcessingState)n.getObjectValue(LicenseProcessingState::createFromDiscriminatorValue)));
        deserializerMap.put("mail", n -> this.setMail(n.getStringValue()));
        deserializerMap.put("mailEnabled", n -> this.setMailEnabled(n.getBooleanValue()));
        deserializerMap.put("mailNickname", n -> this.setMailNickname(n.getStringValue()));
        deserializerMap.put("memberOf", n -> this.setMemberOf(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("members", n -> this.setMembers(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("membershipRule", n -> this.setMembershipRule(n.getStringValue()));
        deserializerMap.put("membershipRuleProcessingState", n -> this.setMembershipRuleProcessingState(n.getStringValue()));
        deserializerMap.put("membersWithLicenseErrors", n -> this.setMembersWithLicenseErrors(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("onenote", n -> this.setOnenote((Onenote)n.getObjectValue(Onenote::createFromDiscriminatorValue)));
        deserializerMap.put("onPremisesDomainName", n -> this.setOnPremisesDomainName(n.getStringValue()));
        deserializerMap.put("onPremisesLastSyncDateTime", n -> this.setOnPremisesLastSyncDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("onPremisesNetBiosName", n -> this.setOnPremisesNetBiosName(n.getStringValue()));
        deserializerMap.put("onPremisesProvisioningErrors", n -> this.setOnPremisesProvisioningErrors(n.getCollectionOfObjectValues(OnPremisesProvisioningError::createFromDiscriminatorValue)));
        deserializerMap.put("onPremisesSamAccountName", n -> this.setOnPremisesSamAccountName(n.getStringValue()));
        deserializerMap.put("onPremisesSecurityIdentifier", n -> this.setOnPremisesSecurityIdentifier(n.getStringValue()));
        deserializerMap.put("onPremisesSyncEnabled", n -> this.setOnPremisesSyncEnabled(n.getBooleanValue()));
        deserializerMap.put("owners", n -> this.setOwners(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("permissionGrants", n -> this.setPermissionGrants(n.getCollectionOfObjectValues(ResourceSpecificPermissionGrant::createFromDiscriminatorValue)));
        deserializerMap.put("photo", n -> this.setPhoto((ProfilePhoto)n.getObjectValue(ProfilePhoto::createFromDiscriminatorValue)));
        deserializerMap.put("photos", n -> this.setPhotos(n.getCollectionOfObjectValues(ProfilePhoto::createFromDiscriminatorValue)));
        deserializerMap.put("planner", n -> this.setPlanner((PlannerGroup)n.getObjectValue(PlannerGroup::createFromDiscriminatorValue)));
        deserializerMap.put("preferredDataLocation", n -> this.setPreferredDataLocation(n.getStringValue()));
        deserializerMap.put("preferredLanguage", n -> this.setPreferredLanguage(n.getStringValue()));
        deserializerMap.put("proxyAddresses", n -> this.setProxyAddresses(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("rejectedSenders", n -> this.setRejectedSenders(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("renewedDateTime", n -> this.setRenewedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("securityEnabled", n -> this.setSecurityEnabled(n.getBooleanValue()));
        deserializerMap.put("securityIdentifier", n -> this.setSecurityIdentifier(n.getStringValue()));
        deserializerMap.put("serviceProvisioningErrors", n -> this.setServiceProvisioningErrors(n.getCollectionOfObjectValues(ServiceProvisioningError::createFromDiscriminatorValue)));
        deserializerMap.put("settings", n -> this.setSettings(n.getCollectionOfObjectValues(GroupSetting::createFromDiscriminatorValue)));
        deserializerMap.put("sites", n -> this.setSites(n.getCollectionOfObjectValues(Site::createFromDiscriminatorValue)));
        deserializerMap.put("team", n -> this.setTeam((Team)n.getObjectValue(Team::createFromDiscriminatorValue)));
        deserializerMap.put("theme", n -> this.setTheme(n.getStringValue()));
        deserializerMap.put("threads", n -> this.setThreads(n.getCollectionOfObjectValues(ConversationThread::createFromDiscriminatorValue)));
        deserializerMap.put("transitiveMemberOf", n -> this.setTransitiveMemberOf(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("transitiveMembers", n -> this.setTransitiveMembers(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("unseenCount", n -> this.setUnseenCount(n.getIntegerValue()));
        deserializerMap.put("visibility", n -> this.setVisibility(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<GroupLifecyclePolicy> getGroupLifecyclePolicies() {
        return (List)this.backingStore.get("groupLifecyclePolicies");
    }

    @Nullable
    public List<String> getGroupTypes() {
        return (List)this.backingStore.get("groupTypes");
    }

    @Nullable
    public Boolean getHasMembersWithLicenseErrors() {
        return (Boolean)this.backingStore.get("hasMembersWithLicenseErrors");
    }

    @Nullable
    public Boolean getHideFromAddressLists() {
        return (Boolean)this.backingStore.get("hideFromAddressLists");
    }

    @Nullable
    public Boolean getHideFromOutlookClients() {
        return (Boolean)this.backingStore.get("hideFromOutlookClients");
    }

    @Nullable
    public Boolean getIsArchived() {
        return (Boolean)this.backingStore.get("isArchived");
    }

    @Nullable
    public Boolean getIsAssignableToRole() {
        return (Boolean)this.backingStore.get("isAssignableToRole");
    }

    @Nullable
    public Boolean getIsSubscribedByMail() {
        return (Boolean)this.backingStore.get("isSubscribedByMail");
    }

    @Nullable
    public LicenseProcessingState getLicenseProcessingState() {
        return (LicenseProcessingState)this.backingStore.get("licenseProcessingState");
    }

    @Nullable
    public String getMail() {
        return (String)this.backingStore.get("mail");
    }

    @Nullable
    public Boolean getMailEnabled() {
        return (Boolean)this.backingStore.get("mailEnabled");
    }

    @Nullable
    public String getMailNickname() {
        return (String)this.backingStore.get("mailNickname");
    }

    @Nullable
    public List<DirectoryObject> getMemberOf() {
        return (List)this.backingStore.get("memberOf");
    }

    @Nullable
    public List<DirectoryObject> getMembers() {
        return (List)this.backingStore.get("members");
    }

    @Nullable
    public String getMembershipRule() {
        return (String)this.backingStore.get("membershipRule");
    }

    @Nullable
    public String getMembershipRuleProcessingState() {
        return (String)this.backingStore.get("membershipRuleProcessingState");
    }

    @Nullable
    public List<DirectoryObject> getMembersWithLicenseErrors() {
        return (List)this.backingStore.get("membersWithLicenseErrors");
    }

    @Nullable
    public Onenote getOnenote() {
        return (Onenote)this.backingStore.get("onenote");
    }

    @Nullable
    public String getOnPremisesDomainName() {
        return (String)this.backingStore.get("onPremisesDomainName");
    }

    @Nullable
    public OffsetDateTime getOnPremisesLastSyncDateTime() {
        return (OffsetDateTime)this.backingStore.get("onPremisesLastSyncDateTime");
    }

    @Nullable
    public String getOnPremisesNetBiosName() {
        return (String)this.backingStore.get("onPremisesNetBiosName");
    }

    @Nullable
    public List<OnPremisesProvisioningError> getOnPremisesProvisioningErrors() {
        return (List)this.backingStore.get("onPremisesProvisioningErrors");
    }

    @Nullable
    public String getOnPremisesSamAccountName() {
        return (String)this.backingStore.get("onPremisesSamAccountName");
    }

    @Nullable
    public String getOnPremisesSecurityIdentifier() {
        return (String)this.backingStore.get("onPremisesSecurityIdentifier");
    }

    @Nullable
    public Boolean getOnPremisesSyncEnabled() {
        return (Boolean)this.backingStore.get("onPremisesSyncEnabled");
    }

    @Nullable
    public List<DirectoryObject> getOwners() {
        return (List)this.backingStore.get("owners");
    }

    @Nullable
    public List<ResourceSpecificPermissionGrant> getPermissionGrants() {
        return (List)this.backingStore.get("permissionGrants");
    }

    @Nullable
    public ProfilePhoto getPhoto() {
        return (ProfilePhoto)this.backingStore.get("photo");
    }

    @Nullable
    public List<ProfilePhoto> getPhotos() {
        return (List)this.backingStore.get("photos");
    }

    @Nullable
    public PlannerGroup getPlanner() {
        return (PlannerGroup)this.backingStore.get("planner");
    }

    @Nullable
    public String getPreferredDataLocation() {
        return (String)this.backingStore.get("preferredDataLocation");
    }

    @Nullable
    public String getPreferredLanguage() {
        return (String)this.backingStore.get("preferredLanguage");
    }

    @Nullable
    public List<String> getProxyAddresses() {
        return (List)this.backingStore.get("proxyAddresses");
    }

    @Nullable
    public List<DirectoryObject> getRejectedSenders() {
        return (List)this.backingStore.get("rejectedSenders");
    }

    @Nullable
    public OffsetDateTime getRenewedDateTime() {
        return (OffsetDateTime)this.backingStore.get("renewedDateTime");
    }

    @Nullable
    public Boolean getSecurityEnabled() {
        return (Boolean)this.backingStore.get("securityEnabled");
    }

    @Nullable
    public String getSecurityIdentifier() {
        return (String)this.backingStore.get("securityIdentifier");
    }

    @Nullable
    public List<ServiceProvisioningError> getServiceProvisioningErrors() {
        return (List)this.backingStore.get("serviceProvisioningErrors");
    }

    @Nullable
    public List<GroupSetting> getSettings() {
        return (List)this.backingStore.get("settings");
    }

    @Nullable
    public List<Site> getSites() {
        return (List)this.backingStore.get("sites");
    }

    @Nullable
    public Team getTeam() {
        return (Team)this.backingStore.get("team");
    }

    @Nullable
    public String getTheme() {
        return (String)this.backingStore.get("theme");
    }

    @Nullable
    public List<ConversationThread> getThreads() {
        return (List)this.backingStore.get("threads");
    }

    @Nullable
    public List<DirectoryObject> getTransitiveMemberOf() {
        return (List)this.backingStore.get("transitiveMemberOf");
    }

    @Nullable
    public List<DirectoryObject> getTransitiveMembers() {
        return (List)this.backingStore.get("transitiveMembers");
    }

    @Nullable
    public Integer getUnseenCount() {
        return (Integer)this.backingStore.get("unseenCount");
    }

    @Nullable
    public String getVisibility() {
        return (String)this.backingStore.get("visibility");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("acceptedSenders", this.getAcceptedSenders());
        writer.writeBooleanValue("allowExternalSenders", this.getAllowExternalSenders());
        writer.writeCollectionOfObjectValues("appRoleAssignments", this.getAppRoleAssignments());
        writer.writeCollectionOfObjectValues("assignedLabels", this.getAssignedLabels());
        writer.writeCollectionOfObjectValues("assignedLicenses", this.getAssignedLicenses());
        writer.writeBooleanValue("autoSubscribeNewMembers", this.getAutoSubscribeNewMembers());
        writer.writeObjectValue("calendar", (Parsable)this.getCalendar(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("calendarView", this.getCalendarView());
        writer.writeStringValue("classification", this.getClassification());
        writer.writeCollectionOfObjectValues("conversations", this.getConversations());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("createdOnBehalfOf", (Parsable)this.getCreatedOnBehalfOf(), new Parsable[0]);
        writer.writeStringValue("description", this.getDescription());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("drive", (Parsable)this.getDrive(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("drives", this.getDrives());
        writer.writeCollectionOfObjectValues("events", this.getEvents());
        writer.writeOffsetDateTimeValue("expirationDateTime", this.getExpirationDateTime());
        writer.writeCollectionOfObjectValues("extensions", this.getExtensions());
        writer.writeCollectionOfObjectValues("groupLifecyclePolicies", this.getGroupLifecyclePolicies());
        writer.writeCollectionOfPrimitiveValues("groupTypes", this.getGroupTypes());
        writer.writeBooleanValue("hasMembersWithLicenseErrors", this.getHasMembersWithLicenseErrors());
        writer.writeBooleanValue("hideFromAddressLists", this.getHideFromAddressLists());
        writer.writeBooleanValue("hideFromOutlookClients", this.getHideFromOutlookClients());
        writer.writeBooleanValue("isArchived", this.getIsArchived());
        writer.writeBooleanValue("isAssignableToRole", this.getIsAssignableToRole());
        writer.writeBooleanValue("isSubscribedByMail", this.getIsSubscribedByMail());
        writer.writeObjectValue("licenseProcessingState", (Parsable)this.getLicenseProcessingState(), new Parsable[0]);
        writer.writeStringValue("mail", this.getMail());
        writer.writeBooleanValue("mailEnabled", this.getMailEnabled());
        writer.writeStringValue("mailNickname", this.getMailNickname());
        writer.writeCollectionOfObjectValues("memberOf", this.getMemberOf());
        writer.writeCollectionOfObjectValues("members", this.getMembers());
        writer.writeStringValue("membershipRule", this.getMembershipRule());
        writer.writeStringValue("membershipRuleProcessingState", this.getMembershipRuleProcessingState());
        writer.writeCollectionOfObjectValues("membersWithLicenseErrors", this.getMembersWithLicenseErrors());
        writer.writeObjectValue("onenote", (Parsable)this.getOnenote(), new Parsable[0]);
        writer.writeStringValue("onPremisesDomainName", this.getOnPremisesDomainName());
        writer.writeOffsetDateTimeValue("onPremisesLastSyncDateTime", this.getOnPremisesLastSyncDateTime());
        writer.writeStringValue("onPremisesNetBiosName", this.getOnPremisesNetBiosName());
        writer.writeCollectionOfObjectValues("onPremisesProvisioningErrors", this.getOnPremisesProvisioningErrors());
        writer.writeStringValue("onPremisesSamAccountName", this.getOnPremisesSamAccountName());
        writer.writeStringValue("onPremisesSecurityIdentifier", this.getOnPremisesSecurityIdentifier());
        writer.writeBooleanValue("onPremisesSyncEnabled", this.getOnPremisesSyncEnabled());
        writer.writeCollectionOfObjectValues("owners", this.getOwners());
        writer.writeCollectionOfObjectValues("permissionGrants", this.getPermissionGrants());
        writer.writeObjectValue("photo", (Parsable)this.getPhoto(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("photos", this.getPhotos());
        writer.writeObjectValue("planner", (Parsable)this.getPlanner(), new Parsable[0]);
        writer.writeStringValue("preferredDataLocation", this.getPreferredDataLocation());
        writer.writeStringValue("preferredLanguage", this.getPreferredLanguage());
        writer.writeCollectionOfPrimitiveValues("proxyAddresses", this.getProxyAddresses());
        writer.writeCollectionOfObjectValues("rejectedSenders", this.getRejectedSenders());
        writer.writeOffsetDateTimeValue("renewedDateTime", this.getRenewedDateTime());
        writer.writeBooleanValue("securityEnabled", this.getSecurityEnabled());
        writer.writeStringValue("securityIdentifier", this.getSecurityIdentifier());
        writer.writeCollectionOfObjectValues("serviceProvisioningErrors", this.getServiceProvisioningErrors());
        writer.writeCollectionOfObjectValues("settings", this.getSettings());
        writer.writeCollectionOfObjectValues("sites", this.getSites());
        writer.writeObjectValue("team", (Parsable)this.getTeam(), new Parsable[0]);
        writer.writeStringValue("theme", this.getTheme());
        writer.writeCollectionOfObjectValues("threads", this.getThreads());
        writer.writeCollectionOfObjectValues("transitiveMemberOf", this.getTransitiveMemberOf());
        writer.writeCollectionOfObjectValues("transitiveMembers", this.getTransitiveMembers());
        writer.writeIntegerValue("unseenCount", this.getUnseenCount());
        writer.writeStringValue("visibility", this.getVisibility());
    }

    public void setAcceptedSenders(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("acceptedSenders", value);
    }

    public void setAllowExternalSenders(@Nullable Boolean value) {
        this.backingStore.set("allowExternalSenders", (Object)value);
    }

    public void setAppRoleAssignments(@Nullable List<AppRoleAssignment> value) {
        this.backingStore.set("appRoleAssignments", value);
    }

    public void setAssignedLabels(@Nullable List<AssignedLabel> value) {
        this.backingStore.set("assignedLabels", value);
    }

    public void setAssignedLicenses(@Nullable List<AssignedLicense> value) {
        this.backingStore.set("assignedLicenses", value);
    }

    public void setAutoSubscribeNewMembers(@Nullable Boolean value) {
        this.backingStore.set("autoSubscribeNewMembers", (Object)value);
    }

    public void setCalendar(@Nullable Calendar value) {
        this.backingStore.set("calendar", (Object)value);
    }

    public void setCalendarView(@Nullable List<Event> value) {
        this.backingStore.set("calendarView", value);
    }

    public void setClassification(@Nullable String value) {
        this.backingStore.set("classification", (Object)value);
    }

    public void setConversations(@Nullable List<Conversation> value) {
        this.backingStore.set("conversations", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCreatedOnBehalfOf(@Nullable DirectoryObject value) {
        this.backingStore.set("createdOnBehalfOf", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setDrive(@Nullable Drive value) {
        this.backingStore.set("drive", (Object)value);
    }

    public void setDrives(@Nullable List<Drive> value) {
        this.backingStore.set("drives", value);
    }

    public void setEvents(@Nullable List<Event> value) {
        this.backingStore.set("events", value);
    }

    public void setExpirationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("expirationDateTime", (Object)value);
    }

    public void setExtensions(@Nullable List<Extension> value) {
        this.backingStore.set("extensions", value);
    }

    public void setGroupLifecyclePolicies(@Nullable List<GroupLifecyclePolicy> value) {
        this.backingStore.set("groupLifecyclePolicies", value);
    }

    public void setGroupTypes(@Nullable List<String> value) {
        this.backingStore.set("groupTypes", value);
    }

    public void setHasMembersWithLicenseErrors(@Nullable Boolean value) {
        this.backingStore.set("hasMembersWithLicenseErrors", (Object)value);
    }

    public void setHideFromAddressLists(@Nullable Boolean value) {
        this.backingStore.set("hideFromAddressLists", (Object)value);
    }

    public void setHideFromOutlookClients(@Nullable Boolean value) {
        this.backingStore.set("hideFromOutlookClients", (Object)value);
    }

    public void setIsArchived(@Nullable Boolean value) {
        this.backingStore.set("isArchived", (Object)value);
    }

    public void setIsAssignableToRole(@Nullable Boolean value) {
        this.backingStore.set("isAssignableToRole", (Object)value);
    }

    public void setIsSubscribedByMail(@Nullable Boolean value) {
        this.backingStore.set("isSubscribedByMail", (Object)value);
    }

    public void setLicenseProcessingState(@Nullable LicenseProcessingState value) {
        this.backingStore.set("licenseProcessingState", (Object)value);
    }

    public void setMail(@Nullable String value) {
        this.backingStore.set("mail", (Object)value);
    }

    public void setMailEnabled(@Nullable Boolean value) {
        this.backingStore.set("mailEnabled", (Object)value);
    }

    public void setMailNickname(@Nullable String value) {
        this.backingStore.set("mailNickname", (Object)value);
    }

    public void setMemberOf(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("memberOf", value);
    }

    public void setMembers(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("members", value);
    }

    public void setMembershipRule(@Nullable String value) {
        this.backingStore.set("membershipRule", (Object)value);
    }

    public void setMembershipRuleProcessingState(@Nullable String value) {
        this.backingStore.set("membershipRuleProcessingState", (Object)value);
    }

    public void setMembersWithLicenseErrors(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("membersWithLicenseErrors", value);
    }

    public void setOnenote(@Nullable Onenote value) {
        this.backingStore.set("onenote", (Object)value);
    }

    public void setOnPremisesDomainName(@Nullable String value) {
        this.backingStore.set("onPremisesDomainName", (Object)value);
    }

    public void setOnPremisesLastSyncDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("onPremisesLastSyncDateTime", (Object)value);
    }

    public void setOnPremisesNetBiosName(@Nullable String value) {
        this.backingStore.set("onPremisesNetBiosName", (Object)value);
    }

    public void setOnPremisesProvisioningErrors(@Nullable List<OnPremisesProvisioningError> value) {
        this.backingStore.set("onPremisesProvisioningErrors", value);
    }

    public void setOnPremisesSamAccountName(@Nullable String value) {
        this.backingStore.set("onPremisesSamAccountName", (Object)value);
    }

    public void setOnPremisesSecurityIdentifier(@Nullable String value) {
        this.backingStore.set("onPremisesSecurityIdentifier", (Object)value);
    }

    public void setOnPremisesSyncEnabled(@Nullable Boolean value) {
        this.backingStore.set("onPremisesSyncEnabled", (Object)value);
    }

    public void setOwners(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("owners", value);
    }

    public void setPermissionGrants(@Nullable List<ResourceSpecificPermissionGrant> value) {
        this.backingStore.set("permissionGrants", value);
    }

    public void setPhoto(@Nullable ProfilePhoto value) {
        this.backingStore.set("photo", (Object)value);
    }

    public void setPhotos(@Nullable List<ProfilePhoto> value) {
        this.backingStore.set("photos", value);
    }

    public void setPlanner(@Nullable PlannerGroup value) {
        this.backingStore.set("planner", (Object)value);
    }

    public void setPreferredDataLocation(@Nullable String value) {
        this.backingStore.set("preferredDataLocation", (Object)value);
    }

    public void setPreferredLanguage(@Nullable String value) {
        this.backingStore.set("preferredLanguage", (Object)value);
    }

    public void setProxyAddresses(@Nullable List<String> value) {
        this.backingStore.set("proxyAddresses", value);
    }

    public void setRejectedSenders(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("rejectedSenders", value);
    }

    public void setRenewedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("renewedDateTime", (Object)value);
    }

    public void setSecurityEnabled(@Nullable Boolean value) {
        this.backingStore.set("securityEnabled", (Object)value);
    }

    public void setSecurityIdentifier(@Nullable String value) {
        this.backingStore.set("securityIdentifier", (Object)value);
    }

    public void setServiceProvisioningErrors(@Nullable List<ServiceProvisioningError> value) {
        this.backingStore.set("serviceProvisioningErrors", value);
    }

    public void setSettings(@Nullable List<GroupSetting> value) {
        this.backingStore.set("settings", value);
    }

    public void setSites(@Nullable List<Site> value) {
        this.backingStore.set("sites", value);
    }

    public void setTeam(@Nullable Team value) {
        this.backingStore.set("team", (Object)value);
    }

    public void setTheme(@Nullable String value) {
        this.backingStore.set("theme", (Object)value);
    }

    public void setThreads(@Nullable List<ConversationThread> value) {
        this.backingStore.set("threads", value);
    }

    public void setTransitiveMemberOf(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("transitiveMemberOf", value);
    }

    public void setTransitiveMembers(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("transitiveMembers", value);
    }

    public void setUnseenCount(@Nullable Integer value) {
        this.backingStore.set("unseenCount", (Object)value);
    }

    public void setVisibility(@Nullable String value) {
        this.backingStore.set("visibility", (Object)value);
    }
}

