/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.drives.item.items.item.workbook;

import com.microsoft.graph.drives.item.items.item.workbook.application.ApplicationRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.closesession.CloseSessionRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.comments.CommentsRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.createsession.CreateSessionRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.functions.FunctionsRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.names.NamesRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.operations.OperationsRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.refreshsession.RefreshSessionRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.sessioninforesourcewithkey.SessionInfoResourceWithKeyRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.tablerowoperationresultwithkey.TableRowOperationResultWithKeyRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.tables.TablesRequestBuilder;
import com.microsoft.graph.drives.item.items.item.workbook.worksheets.WorksheetsRequestBuilder;
import com.microsoft.graph.models.Workbook;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WorkbookRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public ApplicationRequestBuilder application() {
        return new ApplicationRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CloseSessionRequestBuilder closeSession() {
        return new CloseSessionRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CommentsRequestBuilder comments() {
        return new CommentsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CreateSessionRequestBuilder createSession() {
        return new CreateSessionRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public FunctionsRequestBuilder functions() {
        return new FunctionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public NamesRequestBuilder names() {
        return new NamesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public OperationsRequestBuilder operations() {
        return new OperationsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public RefreshSessionRequestBuilder refreshSession() {
        return new RefreshSessionRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TablesRequestBuilder tables() {
        return new TablesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public WorksheetsRequestBuilder worksheets() {
        return new WorksheetsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public WorkbookRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/drives/{drive%2Did}/items/{driveItem%2Did}/workbook{?%24expand,%24select}", pathParameters);
    }

    public WorkbookRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/drives/{drive%2Did}/items/{driveItem%2Did}/workbook{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public Workbook get() {
        return this.get(null);
    }

    @Nullable
    public Workbook get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (Workbook)this.requestAdapter.send(requestInfo, errorMapping, Workbook::createFromDiscriminatorValue);
    }

    @Nullable
    public Workbook patch(@Nonnull Workbook body) {
        return this.patch(body, null);
    }

    @Nullable
    public Workbook patch(@Nonnull Workbook body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (Workbook)this.requestAdapter.send(requestInfo, errorMapping, Workbook::createFromDiscriminatorValue);
    }

    @Nonnull
    public SessionInfoResourceWithKeyRequestBuilder sessionInfoResourceWithKey(@Nonnull String key) {
        Objects.requireNonNull(key);
        return new SessionInfoResourceWithKeyRequestBuilder(this.pathParameters, this.requestAdapter, key);
    }

    @Nonnull
    public TableRowOperationResultWithKeyRequestBuilder tableRowOperationResultWithKey(@Nonnull String key) {
        Objects.requireNonNull(key);
        return new TableRowOperationResultWithKeyRequestBuilder(this.pathParameters, this.requestAdapter, key);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Workbook body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Workbook body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public WorkbookRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new WorkbookRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

