package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
/**
 * Malware information entity.
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public class WindowsMalwareInformation extends Entity implements Parsable {
    /**
     * Instantiates a new WindowsMalwareInformation and sets the default values.
     */
    public WindowsMalwareInformation() {
        super();
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a WindowsMalwareInformation
     */
    @jakarta.annotation.Nonnull
    public static WindowsMalwareInformation createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsMalwareInformation();
    }
    /**
     * Gets the additionalInformationUrl property value. Indicates an informational URL to learn more about the malware
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getAdditionalInformationUrl() {
        return this.backingStore.get("additionalInformationUrl");
    }
    /**
     * Gets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule. default value is invalid. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
     * @return a WindowsMalwareCategory
     */
    @jakarta.annotation.Nullable
    public WindowsMalwareCategory getCategory() {
        return this.backingStore.get("category");
    }
    /**
     * Gets the deviceMalwareStates property value. List of devices affected by current malware with the malware state on each device
     * @return a java.util.List<MalwareStateForWindowsDevice>
     */
    @jakarta.annotation.Nullable
    public java.util.List<MalwareStateForWindowsDevice> getDeviceMalwareStates() {
        return this.backingStore.get("deviceMalwareStates");
    }
    /**
     * Gets the displayName property value. Indicates the name of the malware
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getDisplayName() {
        return this.backingStore.get("displayName");
    }
    /**
     * The deserialization information for the current model
     * @return a Map<String, java.util.function.Consumer<ParseNode>>
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("additionalInformationUrl", (n) -> { this.setAdditionalInformationUrl(n.getStringValue()); });
        deserializerMap.put("category", (n) -> { this.setCategory(n.getEnumValue(WindowsMalwareCategory::forValue)); });
        deserializerMap.put("deviceMalwareStates", (n) -> { this.setDeviceMalwareStates(n.getCollectionOfObjectValues(MalwareStateForWindowsDevice::createFromDiscriminatorValue)); });
        deserializerMap.put("displayName", (n) -> { this.setDisplayName(n.getStringValue()); });
        deserializerMap.put("lastDetectionDateTime", (n) -> { this.setLastDetectionDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("severity", (n) -> { this.setSeverity(n.getEnumValue(WindowsMalwareSeverity::forValue)); });
        return deserializerMap;
    }
    /**
     * Gets the lastDetectionDateTime property value. Indicates the last time the malware was detected in UTC
     * @return a OffsetDateTime
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastDetectionDateTime() {
        return this.backingStore.get("lastDetectionDateTime");
    }
    /**
     * Gets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe. default is unknown. Possible values are: unknown, low, moderate, high, severe.
     * @return a WindowsMalwareSeverity
     */
    @jakarta.annotation.Nullable
    public WindowsMalwareSeverity getSeverity() {
        return this.backingStore.get("severity");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("additionalInformationUrl", this.getAdditionalInformationUrl());
        writer.writeEnumValue("category", this.getCategory());
        writer.writeCollectionOfObjectValues("deviceMalwareStates", this.getDeviceMalwareStates());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeOffsetDateTimeValue("lastDetectionDateTime", this.getLastDetectionDateTime());
        writer.writeEnumValue("severity", this.getSeverity());
    }
    /**
     * Sets the additionalInformationUrl property value. Indicates an informational URL to learn more about the malware
     * @param value Value to set for the additionalInformationUrl property.
     */
    public void setAdditionalInformationUrl(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("additionalInformationUrl", value);
    }
    /**
     * Sets the category property value. Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule. default value is invalid. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remoteControlSoftware, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
     * @param value Value to set for the category property.
     */
    public void setCategory(@jakarta.annotation.Nullable final WindowsMalwareCategory value) {
        this.backingStore.set("category", value);
    }
    /**
     * Sets the deviceMalwareStates property value. List of devices affected by current malware with the malware state on each device
     * @param value Value to set for the deviceMalwareStates property.
     */
    public void setDeviceMalwareStates(@jakarta.annotation.Nullable final java.util.List<MalwareStateForWindowsDevice> value) {
        this.backingStore.set("deviceMalwareStates", value);
    }
    /**
     * Sets the displayName property value. Indicates the name of the malware
     * @param value Value to set for the displayName property.
     */
    public void setDisplayName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("displayName", value);
    }
    /**
     * Sets the lastDetectionDateTime property value. Indicates the last time the malware was detected in UTC
     * @param value Value to set for the lastDetectionDateTime property.
     */
    public void setLastDetectionDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastDetectionDateTime", value);
    }
    /**
     * Sets the severity property value. Severity of the malware. Possible values are: unknown, low, moderate, high, severe. default is unknown. Possible values are: unknown, low, moderate, high, severe.
     * @param value Value to set for the severity property.
     */
    public void setSeverity(@jakarta.annotation.Nullable final WindowsMalwareSeverity value) {
        this.backingStore.set("severity", value);
    }
}
