package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class Alert extends Entity implements Parsable {
    /**
     * Instantiates a new Alert and sets the default values.
     */
    public Alert() {
        super();
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a Alert
     */
    @jakarta.annotation.Nonnull
    public static Alert createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Alert();
    }
    /**
     * Gets the activityGroupName property value. Name or alias of the activity group (attacker) this alert is attributed to.
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getActivityGroupName() {
        return this.backingStore.get("activityGroupName");
    }
    /**
     * Gets the alertDetections property value. The alertDetections property
     * @return a java.util.List<AlertDetection>
     */
    @jakarta.annotation.Nullable
    public java.util.List<AlertDetection> getAlertDetections() {
        return this.backingStore.get("alertDetections");
    }
    /**
     * Gets the assignedTo property value. Name of the analyst the alert is assigned to for triage, investigation, or remediation (supports update).
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getAssignedTo() {
        return this.backingStore.get("assignedTo");
    }
    /**
     * Gets the azureSubscriptionId property value. Azure subscription ID, present if this alert is related to an Azure resource.
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getAzureSubscriptionId() {
        return this.backingStore.get("azureSubscriptionId");
    }
    /**
     * Gets the azureTenantId property value. Microsoft Entra tenant ID. Required.
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getAzureTenantId() {
        return this.backingStore.get("azureTenantId");
    }
    /**
     * Gets the category property value. Category of the alert (for example, credentialTheft, ransomware, etc.).
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getCategory() {
        return this.backingStore.get("category");
    }
    /**
     * Gets the closedDateTime property value. Time at which the alert was closed. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z (supports update).
     * @return a OffsetDateTime
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getClosedDateTime() {
        return this.backingStore.get("closedDateTime");
    }
    /**
     * Gets the cloudAppStates property value. Security-related stateful information generated by the provider about the cloud application/s related to this alert.
     * @return a java.util.List<CloudAppSecurityState>
     */
    @jakarta.annotation.Nullable
    public java.util.List<CloudAppSecurityState> getCloudAppStates() {
        return this.backingStore.get("cloudAppStates");
    }
    /**
     * Gets the comments property value. Customer-provided comments on alert (for customer alert management) (supports update).
     * @return a java.util.List<String>
     */
    @jakarta.annotation.Nullable
    public java.util.List<String> getComments() {
        return this.backingStore.get("comments");
    }
    /**
     * Gets the confidence property value. Confidence of the detection logic (percentage between 1-100).
     * @return a Integer
     */
    @jakarta.annotation.Nullable
    public Integer getConfidence() {
        return this.backingStore.get("confidence");
    }
    /**
     * Gets the createdDateTime property value. Time at which the alert was created by the alert provider. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
     * @return a OffsetDateTime
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getCreatedDateTime() {
        return this.backingStore.get("createdDateTime");
    }
    /**
     * Gets the description property value. Alert description.
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getDescription() {
        return this.backingStore.get("description");
    }
    /**
     * Gets the detectionIds property value. Set of alerts related to this alert entity (each alert is pushed to the SIEM as a separate record).
     * @return a java.util.List<String>
     */
    @jakarta.annotation.Nullable
    public java.util.List<String> getDetectionIds() {
        return this.backingStore.get("detectionIds");
    }
    /**
     * Gets the eventDateTime property value. Time at which the event(s) that served as the trigger(s) to generate the alert occurred. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
     * @return a OffsetDateTime
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getEventDateTime() {
        return this.backingStore.get("eventDateTime");
    }
    /**
     * Gets the feedback property value. Analyst feedback on the alert. Possible values are: unknown, truePositive, falsePositive, benignPositive. (supports update)
     * @return a AlertFeedback
     */
    @jakarta.annotation.Nullable
    public AlertFeedback getFeedback() {
        return this.backingStore.get("feedback");
    }
    /**
     * The deserialization information for the current model
     * @return a Map<String, java.util.function.Consumer<ParseNode>>
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activityGroupName", (n) -> { this.setActivityGroupName(n.getStringValue()); });
        deserializerMap.put("alertDetections", (n) -> { this.setAlertDetections(n.getCollectionOfObjectValues(AlertDetection::createFromDiscriminatorValue)); });
        deserializerMap.put("assignedTo", (n) -> { this.setAssignedTo(n.getStringValue()); });
        deserializerMap.put("azureSubscriptionId", (n) -> { this.setAzureSubscriptionId(n.getStringValue()); });
        deserializerMap.put("azureTenantId", (n) -> { this.setAzureTenantId(n.getStringValue()); });
        deserializerMap.put("category", (n) -> { this.setCategory(n.getStringValue()); });
        deserializerMap.put("closedDateTime", (n) -> { this.setClosedDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("cloudAppStates", (n) -> { this.setCloudAppStates(n.getCollectionOfObjectValues(CloudAppSecurityState::createFromDiscriminatorValue)); });
        deserializerMap.put("comments", (n) -> { this.setComments(n.getCollectionOfPrimitiveValues(String.class)); });
        deserializerMap.put("confidence", (n) -> { this.setConfidence(n.getIntegerValue()); });
        deserializerMap.put("createdDateTime", (n) -> { this.setCreatedDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("description", (n) -> { this.setDescription(n.getStringValue()); });
        deserializerMap.put("detectionIds", (n) -> { this.setDetectionIds(n.getCollectionOfPrimitiveValues(String.class)); });
        deserializerMap.put("eventDateTime", (n) -> { this.setEventDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("feedback", (n) -> { this.setFeedback(n.getEnumValue(AlertFeedback::forValue)); });
        deserializerMap.put("fileStates", (n) -> { this.setFileStates(n.getCollectionOfObjectValues(FileSecurityState::createFromDiscriminatorValue)); });
        deserializerMap.put("historyStates", (n) -> { this.setHistoryStates(n.getCollectionOfObjectValues(AlertHistoryState::createFromDiscriminatorValue)); });
        deserializerMap.put("hostStates", (n) -> { this.setHostStates(n.getCollectionOfObjectValues(HostSecurityState::createFromDiscriminatorValue)); });
        deserializerMap.put("incidentIds", (n) -> { this.setIncidentIds(n.getCollectionOfPrimitiveValues(String.class)); });
        deserializerMap.put("investigationSecurityStates", (n) -> { this.setInvestigationSecurityStates(n.getCollectionOfObjectValues(InvestigationSecurityState::createFromDiscriminatorValue)); });
        deserializerMap.put("lastEventDateTime", (n) -> { this.setLastEventDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("lastModifiedDateTime", (n) -> { this.setLastModifiedDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("malwareStates", (n) -> { this.setMalwareStates(n.getCollectionOfObjectValues(MalwareState::createFromDiscriminatorValue)); });
        deserializerMap.put("messageSecurityStates", (n) -> { this.setMessageSecurityStates(n.getCollectionOfObjectValues(MessageSecurityState::createFromDiscriminatorValue)); });
        deserializerMap.put("networkConnections", (n) -> { this.setNetworkConnections(n.getCollectionOfObjectValues(NetworkConnection::createFromDiscriminatorValue)); });
        deserializerMap.put("processes", (n) -> { this.setProcesses(n.getCollectionOfObjectValues(Process::createFromDiscriminatorValue)); });
        deserializerMap.put("recommendedActions", (n) -> { this.setRecommendedActions(n.getCollectionOfPrimitiveValues(String.class)); });
        deserializerMap.put("registryKeyStates", (n) -> { this.setRegistryKeyStates(n.getCollectionOfObjectValues(RegistryKeyState::createFromDiscriminatorValue)); });
        deserializerMap.put("securityResources", (n) -> { this.setSecurityResources(n.getCollectionOfObjectValues(SecurityResource::createFromDiscriminatorValue)); });
        deserializerMap.put("severity", (n) -> { this.setSeverity(n.getEnumValue(AlertSeverity::forValue)); });
        deserializerMap.put("sourceMaterials", (n) -> { this.setSourceMaterials(n.getCollectionOfPrimitiveValues(String.class)); });
        deserializerMap.put("status", (n) -> { this.setStatus(n.getEnumValue(AlertStatus::forValue)); });
        deserializerMap.put("tags", (n) -> { this.setTags(n.getCollectionOfPrimitiveValues(String.class)); });
        deserializerMap.put("title", (n) -> { this.setTitle(n.getStringValue()); });
        deserializerMap.put("triggers", (n) -> { this.setTriggers(n.getCollectionOfObjectValues(AlertTrigger::createFromDiscriminatorValue)); });
        deserializerMap.put("uriClickSecurityStates", (n) -> { this.setUriClickSecurityStates(n.getCollectionOfObjectValues(UriClickSecurityState::createFromDiscriminatorValue)); });
        deserializerMap.put("userStates", (n) -> { this.setUserStates(n.getCollectionOfObjectValues(UserSecurityState::createFromDiscriminatorValue)); });
        deserializerMap.put("vendorInformation", (n) -> { this.setVendorInformation(n.getObjectValue(SecurityVendorInformation::createFromDiscriminatorValue)); });
        deserializerMap.put("vulnerabilityStates", (n) -> { this.setVulnerabilityStates(n.getCollectionOfObjectValues(VulnerabilityState::createFromDiscriminatorValue)); });
        return deserializerMap;
    }
    /**
     * Gets the fileStates property value. Security-related stateful information generated by the provider about the file(s) related to this alert.
     * @return a java.util.List<FileSecurityState>
     */
    @jakarta.annotation.Nullable
    public java.util.List<FileSecurityState> getFileStates() {
        return this.backingStore.get("fileStates");
    }
    /**
     * Gets the historyStates property value. The historyStates property
     * @return a java.util.List<AlertHistoryState>
     */
    @jakarta.annotation.Nullable
    public java.util.List<AlertHistoryState> getHistoryStates() {
        return this.backingStore.get("historyStates");
    }
    /**
     * Gets the hostStates property value. Security-related stateful information generated by the provider about the host(s) related to this alert.
     * @return a java.util.List<HostSecurityState>
     */
    @jakarta.annotation.Nullable
    public java.util.List<HostSecurityState> getHostStates() {
        return this.backingStore.get("hostStates");
    }
    /**
     * Gets the incidentIds property value. IDs of incidents related to current alert.
     * @return a java.util.List<String>
     */
    @jakarta.annotation.Nullable
    public java.util.List<String> getIncidentIds() {
        return this.backingStore.get("incidentIds");
    }
    /**
     * Gets the investigationSecurityStates property value. The investigationSecurityStates property
     * @return a java.util.List<InvestigationSecurityState>
     */
    @jakarta.annotation.Nullable
    public java.util.List<InvestigationSecurityState> getInvestigationSecurityStates() {
        return this.backingStore.get("investigationSecurityStates");
    }
    /**
     * Gets the lastEventDateTime property value. The lastEventDateTime property
     * @return a OffsetDateTime
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastEventDateTime() {
        return this.backingStore.get("lastEventDateTime");
    }
    /**
     * Gets the lastModifiedDateTime property value. Time at which the alert entity was last modified. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     * @return a OffsetDateTime
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return this.backingStore.get("lastModifiedDateTime");
    }
    /**
     * Gets the malwareStates property value. Threat Intelligence pertaining to malware related to this alert.
     * @return a java.util.List<MalwareState>
     */
    @jakarta.annotation.Nullable
    public java.util.List<MalwareState> getMalwareStates() {
        return this.backingStore.get("malwareStates");
    }
    /**
     * Gets the messageSecurityStates property value. The messageSecurityStates property
     * @return a java.util.List<MessageSecurityState>
     */
    @jakarta.annotation.Nullable
    public java.util.List<MessageSecurityState> getMessageSecurityStates() {
        return this.backingStore.get("messageSecurityStates");
    }
    /**
     * Gets the networkConnections property value. Security-related stateful information generated by the provider about the network connection(s) related to this alert.
     * @return a java.util.List<NetworkConnection>
     */
    @jakarta.annotation.Nullable
    public java.util.List<NetworkConnection> getNetworkConnections() {
        return this.backingStore.get("networkConnections");
    }
    /**
     * Gets the processes property value. Security-related stateful information generated by the provider about the process or processes related to this alert.
     * @return a java.util.List<Process>
     */
    @jakarta.annotation.Nullable
    public java.util.List<Process> getProcesses() {
        return this.backingStore.get("processes");
    }
    /**
     * Gets the recommendedActions property value. Vendor/provider recommended action(s) to take as a result of the alert (for example, isolate machine, enforce2FA, reimage host).
     * @return a java.util.List<String>
     */
    @jakarta.annotation.Nullable
    public java.util.List<String> getRecommendedActions() {
        return this.backingStore.get("recommendedActions");
    }
    /**
     * Gets the registryKeyStates property value. Security-related stateful information generated by the provider about the registry keys related to this alert.
     * @return a java.util.List<RegistryKeyState>
     */
    @jakarta.annotation.Nullable
    public java.util.List<RegistryKeyState> getRegistryKeyStates() {
        return this.backingStore.get("registryKeyStates");
    }
    /**
     * Gets the securityResources property value. Resources related to current alert. For example, for some alerts this can have the Azure Resource value.
     * @return a java.util.List<SecurityResource>
     */
    @jakarta.annotation.Nullable
    public java.util.List<SecurityResource> getSecurityResources() {
        return this.backingStore.get("securityResources");
    }
    /**
     * Gets the severity property value. The severity property
     * @return a AlertSeverity
     */
    @jakarta.annotation.Nullable
    public AlertSeverity getSeverity() {
        return this.backingStore.get("severity");
    }
    /**
     * Gets the sourceMaterials property value. Hyperlinks (URIs) to the source material related to the alert, for example, provider's user interface for alerts or log search, etc.
     * @return a java.util.List<String>
     */
    @jakarta.annotation.Nullable
    public java.util.List<String> getSourceMaterials() {
        return this.backingStore.get("sourceMaterials");
    }
    /**
     * Gets the status property value. The status property
     * @return a AlertStatus
     */
    @jakarta.annotation.Nullable
    public AlertStatus getStatus() {
        return this.backingStore.get("status");
    }
    /**
     * Gets the tags property value. User-definable labels that can be applied to an alert and can serve as filter conditions (for example 'HVA', 'SAW', etc.) (supports update).
     * @return a java.util.List<String>
     */
    @jakarta.annotation.Nullable
    public java.util.List<String> getTags() {
        return this.backingStore.get("tags");
    }
    /**
     * Gets the title property value. Alert title. Required.
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getTitle() {
        return this.backingStore.get("title");
    }
    /**
     * Gets the triggers property value. Security-related information about the specific properties that triggered the alert (properties appearing in the alert). Alerts might contain information about multiple users, hosts, files, ip addresses. This field indicates which properties triggered the alert generation.
     * @return a java.util.List<AlertTrigger>
     */
    @jakarta.annotation.Nullable
    public java.util.List<AlertTrigger> getTriggers() {
        return this.backingStore.get("triggers");
    }
    /**
     * Gets the uriClickSecurityStates property value. The uriClickSecurityStates property
     * @return a java.util.List<UriClickSecurityState>
     */
    @jakarta.annotation.Nullable
    public java.util.List<UriClickSecurityState> getUriClickSecurityStates() {
        return this.backingStore.get("uriClickSecurityStates");
    }
    /**
     * Gets the userStates property value. Security-related stateful information generated by the provider about the user accounts related to this alert.
     * @return a java.util.List<UserSecurityState>
     */
    @jakarta.annotation.Nullable
    public java.util.List<UserSecurityState> getUserStates() {
        return this.backingStore.get("userStates");
    }
    /**
     * Gets the vendorInformation property value. Complex type containing details about the security product/service vendor, provider, and subprovider (for example, vendor=Microsoft; provider=Windows Defender ATP; subProvider=AppLocker). Required.
     * @return a SecurityVendorInformation
     */
    @jakarta.annotation.Nullable
    public SecurityVendorInformation getVendorInformation() {
        return this.backingStore.get("vendorInformation");
    }
    /**
     * Gets the vulnerabilityStates property value. Threat intelligence pertaining to one or more vulnerabilities related to this alert.
     * @return a java.util.List<VulnerabilityState>
     */
    @jakarta.annotation.Nullable
    public java.util.List<VulnerabilityState> getVulnerabilityStates() {
        return this.backingStore.get("vulnerabilityStates");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("activityGroupName", this.getActivityGroupName());
        writer.writeCollectionOfObjectValues("alertDetections", this.getAlertDetections());
        writer.writeStringValue("assignedTo", this.getAssignedTo());
        writer.writeStringValue("azureSubscriptionId", this.getAzureSubscriptionId());
        writer.writeStringValue("azureTenantId", this.getAzureTenantId());
        writer.writeStringValue("category", this.getCategory());
        writer.writeOffsetDateTimeValue("closedDateTime", this.getClosedDateTime());
        writer.writeCollectionOfObjectValues("cloudAppStates", this.getCloudAppStates());
        writer.writeCollectionOfPrimitiveValues("comments", this.getComments());
        writer.writeIntegerValue("confidence", this.getConfidence());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeCollectionOfPrimitiveValues("detectionIds", this.getDetectionIds());
        writer.writeOffsetDateTimeValue("eventDateTime", this.getEventDateTime());
        writer.writeEnumValue("feedback", this.getFeedback());
        writer.writeCollectionOfObjectValues("fileStates", this.getFileStates());
        writer.writeCollectionOfObjectValues("historyStates", this.getHistoryStates());
        writer.writeCollectionOfObjectValues("hostStates", this.getHostStates());
        writer.writeCollectionOfPrimitiveValues("incidentIds", this.getIncidentIds());
        writer.writeCollectionOfObjectValues("investigationSecurityStates", this.getInvestigationSecurityStates());
        writer.writeOffsetDateTimeValue("lastEventDateTime", this.getLastEventDateTime());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeCollectionOfObjectValues("malwareStates", this.getMalwareStates());
        writer.writeCollectionOfObjectValues("messageSecurityStates", this.getMessageSecurityStates());
        writer.writeCollectionOfObjectValues("networkConnections", this.getNetworkConnections());
        writer.writeCollectionOfObjectValues("processes", this.getProcesses());
        writer.writeCollectionOfPrimitiveValues("recommendedActions", this.getRecommendedActions());
        writer.writeCollectionOfObjectValues("registryKeyStates", this.getRegistryKeyStates());
        writer.writeCollectionOfObjectValues("securityResources", this.getSecurityResources());
        writer.writeEnumValue("severity", this.getSeverity());
        writer.writeCollectionOfPrimitiveValues("sourceMaterials", this.getSourceMaterials());
        writer.writeEnumValue("status", this.getStatus());
        writer.writeCollectionOfPrimitiveValues("tags", this.getTags());
        writer.writeStringValue("title", this.getTitle());
        writer.writeCollectionOfObjectValues("triggers", this.getTriggers());
        writer.writeCollectionOfObjectValues("uriClickSecurityStates", this.getUriClickSecurityStates());
        writer.writeCollectionOfObjectValues("userStates", this.getUserStates());
        writer.writeObjectValue("vendorInformation", this.getVendorInformation());
        writer.writeCollectionOfObjectValues("vulnerabilityStates", this.getVulnerabilityStates());
    }
    /**
     * Sets the activityGroupName property value. Name or alias of the activity group (attacker) this alert is attributed to.
     * @param value Value to set for the activityGroupName property.
     */
    public void setActivityGroupName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("activityGroupName", value);
    }
    /**
     * Sets the alertDetections property value. The alertDetections property
     * @param value Value to set for the alertDetections property.
     */
    public void setAlertDetections(@jakarta.annotation.Nullable final java.util.List<AlertDetection> value) {
        this.backingStore.set("alertDetections", value);
    }
    /**
     * Sets the assignedTo property value. Name of the analyst the alert is assigned to for triage, investigation, or remediation (supports update).
     * @param value Value to set for the assignedTo property.
     */
    public void setAssignedTo(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("assignedTo", value);
    }
    /**
     * Sets the azureSubscriptionId property value. Azure subscription ID, present if this alert is related to an Azure resource.
     * @param value Value to set for the azureSubscriptionId property.
     */
    public void setAzureSubscriptionId(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("azureSubscriptionId", value);
    }
    /**
     * Sets the azureTenantId property value. Microsoft Entra tenant ID. Required.
     * @param value Value to set for the azureTenantId property.
     */
    public void setAzureTenantId(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("azureTenantId", value);
    }
    /**
     * Sets the category property value. Category of the alert (for example, credentialTheft, ransomware, etc.).
     * @param value Value to set for the category property.
     */
    public void setCategory(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("category", value);
    }
    /**
     * Sets the closedDateTime property value. Time at which the alert was closed. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z (supports update).
     * @param value Value to set for the closedDateTime property.
     */
    public void setClosedDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("closedDateTime", value);
    }
    /**
     * Sets the cloudAppStates property value. Security-related stateful information generated by the provider about the cloud application/s related to this alert.
     * @param value Value to set for the cloudAppStates property.
     */
    public void setCloudAppStates(@jakarta.annotation.Nullable final java.util.List<CloudAppSecurityState> value) {
        this.backingStore.set("cloudAppStates", value);
    }
    /**
     * Sets the comments property value. Customer-provided comments on alert (for customer alert management) (supports update).
     * @param value Value to set for the comments property.
     */
    public void setComments(@jakarta.annotation.Nullable final java.util.List<String> value) {
        this.backingStore.set("comments", value);
    }
    /**
     * Sets the confidence property value. Confidence of the detection logic (percentage between 1-100).
     * @param value Value to set for the confidence property.
     */
    public void setConfidence(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("confidence", value);
    }
    /**
     * Sets the createdDateTime property value. Time at which the alert was created by the alert provider. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
     * @param value Value to set for the createdDateTime property.
     */
    public void setCreatedDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("createdDateTime", value);
    }
    /**
     * Sets the description property value. Alert description.
     * @param value Value to set for the description property.
     */
    public void setDescription(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("description", value);
    }
    /**
     * Sets the detectionIds property value. Set of alerts related to this alert entity (each alert is pushed to the SIEM as a separate record).
     * @param value Value to set for the detectionIds property.
     */
    public void setDetectionIds(@jakarta.annotation.Nullable final java.util.List<String> value) {
        this.backingStore.set("detectionIds", value);
    }
    /**
     * Sets the eventDateTime property value. Time at which the event(s) that served as the trigger(s) to generate the alert occurred. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
     * @param value Value to set for the eventDateTime property.
     */
    public void setEventDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("eventDateTime", value);
    }
    /**
     * Sets the feedback property value. Analyst feedback on the alert. Possible values are: unknown, truePositive, falsePositive, benignPositive. (supports update)
     * @param value Value to set for the feedback property.
     */
    public void setFeedback(@jakarta.annotation.Nullable final AlertFeedback value) {
        this.backingStore.set("feedback", value);
    }
    /**
     * Sets the fileStates property value. Security-related stateful information generated by the provider about the file(s) related to this alert.
     * @param value Value to set for the fileStates property.
     */
    public void setFileStates(@jakarta.annotation.Nullable final java.util.List<FileSecurityState> value) {
        this.backingStore.set("fileStates", value);
    }
    /**
     * Sets the historyStates property value. The historyStates property
     * @param value Value to set for the historyStates property.
     */
    public void setHistoryStates(@jakarta.annotation.Nullable final java.util.List<AlertHistoryState> value) {
        this.backingStore.set("historyStates", value);
    }
    /**
     * Sets the hostStates property value. Security-related stateful information generated by the provider about the host(s) related to this alert.
     * @param value Value to set for the hostStates property.
     */
    public void setHostStates(@jakarta.annotation.Nullable final java.util.List<HostSecurityState> value) {
        this.backingStore.set("hostStates", value);
    }
    /**
     * Sets the incidentIds property value. IDs of incidents related to current alert.
     * @param value Value to set for the incidentIds property.
     */
    public void setIncidentIds(@jakarta.annotation.Nullable final java.util.List<String> value) {
        this.backingStore.set("incidentIds", value);
    }
    /**
     * Sets the investigationSecurityStates property value. The investigationSecurityStates property
     * @param value Value to set for the investigationSecurityStates property.
     */
    public void setInvestigationSecurityStates(@jakarta.annotation.Nullable final java.util.List<InvestigationSecurityState> value) {
        this.backingStore.set("investigationSecurityStates", value);
    }
    /**
     * Sets the lastEventDateTime property value. The lastEventDateTime property
     * @param value Value to set for the lastEventDateTime property.
     */
    public void setLastEventDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastEventDateTime", value);
    }
    /**
     * Sets the lastModifiedDateTime property value. Time at which the alert entity was last modified. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     * @param value Value to set for the lastModifiedDateTime property.
     */
    public void setLastModifiedDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", value);
    }
    /**
     * Sets the malwareStates property value. Threat Intelligence pertaining to malware related to this alert.
     * @param value Value to set for the malwareStates property.
     */
    public void setMalwareStates(@jakarta.annotation.Nullable final java.util.List<MalwareState> value) {
        this.backingStore.set("malwareStates", value);
    }
    /**
     * Sets the messageSecurityStates property value. The messageSecurityStates property
     * @param value Value to set for the messageSecurityStates property.
     */
    public void setMessageSecurityStates(@jakarta.annotation.Nullable final java.util.List<MessageSecurityState> value) {
        this.backingStore.set("messageSecurityStates", value);
    }
    /**
     * Sets the networkConnections property value. Security-related stateful information generated by the provider about the network connection(s) related to this alert.
     * @param value Value to set for the networkConnections property.
     */
    public void setNetworkConnections(@jakarta.annotation.Nullable final java.util.List<NetworkConnection> value) {
        this.backingStore.set("networkConnections", value);
    }
    /**
     * Sets the processes property value. Security-related stateful information generated by the provider about the process or processes related to this alert.
     * @param value Value to set for the processes property.
     */
    public void setProcesses(@jakarta.annotation.Nullable final java.util.List<Process> value) {
        this.backingStore.set("processes", value);
    }
    /**
     * Sets the recommendedActions property value. Vendor/provider recommended action(s) to take as a result of the alert (for example, isolate machine, enforce2FA, reimage host).
     * @param value Value to set for the recommendedActions property.
     */
    public void setRecommendedActions(@jakarta.annotation.Nullable final java.util.List<String> value) {
        this.backingStore.set("recommendedActions", value);
    }
    /**
     * Sets the registryKeyStates property value. Security-related stateful information generated by the provider about the registry keys related to this alert.
     * @param value Value to set for the registryKeyStates property.
     */
    public void setRegistryKeyStates(@jakarta.annotation.Nullable final java.util.List<RegistryKeyState> value) {
        this.backingStore.set("registryKeyStates", value);
    }
    /**
     * Sets the securityResources property value. Resources related to current alert. For example, for some alerts this can have the Azure Resource value.
     * @param value Value to set for the securityResources property.
     */
    public void setSecurityResources(@jakarta.annotation.Nullable final java.util.List<SecurityResource> value) {
        this.backingStore.set("securityResources", value);
    }
    /**
     * Sets the severity property value. The severity property
     * @param value Value to set for the severity property.
     */
    public void setSeverity(@jakarta.annotation.Nullable final AlertSeverity value) {
        this.backingStore.set("severity", value);
    }
    /**
     * Sets the sourceMaterials property value. Hyperlinks (URIs) to the source material related to the alert, for example, provider's user interface for alerts or log search, etc.
     * @param value Value to set for the sourceMaterials property.
     */
    public void setSourceMaterials(@jakarta.annotation.Nullable final java.util.List<String> value) {
        this.backingStore.set("sourceMaterials", value);
    }
    /**
     * Sets the status property value. The status property
     * @param value Value to set for the status property.
     */
    public void setStatus(@jakarta.annotation.Nullable final AlertStatus value) {
        this.backingStore.set("status", value);
    }
    /**
     * Sets the tags property value. User-definable labels that can be applied to an alert and can serve as filter conditions (for example 'HVA', 'SAW', etc.) (supports update).
     * @param value Value to set for the tags property.
     */
    public void setTags(@jakarta.annotation.Nullable final java.util.List<String> value) {
        this.backingStore.set("tags", value);
    }
    /**
     * Sets the title property value. Alert title. Required.
     * @param value Value to set for the title property.
     */
    public void setTitle(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("title", value);
    }
    /**
     * Sets the triggers property value. Security-related information about the specific properties that triggered the alert (properties appearing in the alert). Alerts might contain information about multiple users, hosts, files, ip addresses. This field indicates which properties triggered the alert generation.
     * @param value Value to set for the triggers property.
     */
    public void setTriggers(@jakarta.annotation.Nullable final java.util.List<AlertTrigger> value) {
        this.backingStore.set("triggers", value);
    }
    /**
     * Sets the uriClickSecurityStates property value. The uriClickSecurityStates property
     * @param value Value to set for the uriClickSecurityStates property.
     */
    public void setUriClickSecurityStates(@jakarta.annotation.Nullable final java.util.List<UriClickSecurityState> value) {
        this.backingStore.set("uriClickSecurityStates", value);
    }
    /**
     * Sets the userStates property value. Security-related stateful information generated by the provider about the user accounts related to this alert.
     * @param value Value to set for the userStates property.
     */
    public void setUserStates(@jakarta.annotation.Nullable final java.util.List<UserSecurityState> value) {
        this.backingStore.set("userStates", value);
    }
    /**
     * Sets the vendorInformation property value. Complex type containing details about the security product/service vendor, provider, and subprovider (for example, vendor=Microsoft; provider=Windows Defender ATP; subProvider=AppLocker). Required.
     * @param value Value to set for the vendorInformation property.
     */
    public void setVendorInformation(@jakarta.annotation.Nullable final SecurityVendorInformation value) {
        this.backingStore.set("vendorInformation", value);
    }
    /**
     * Sets the vulnerabilityStates property value. Threat intelligence pertaining to one or more vulnerabilities related to this alert.
     * @param value Value to set for the vulnerabilityStates property.
     */
    public void setVulnerabilityStates(@jakarta.annotation.Nullable final java.util.List<VulnerabilityState> value) {
        this.backingStore.set("vulnerabilityStates", value);
    }
}
