// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.FileAttachment;
import com.microsoft.graph.models.AttachmentItem;
import com.microsoft.graph.models.UploadSession;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the File Attachment Request.
 */
public class FileAttachmentRequest extends BaseRequest<FileAttachment> {
	
    /**
     * The request for the FileAttachment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public FileAttachmentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, FileAttachment.class);
    }

    /**
     * Gets the FileAttachment from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FileAttachment> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the FileAttachment from the service
     *
     * @return the FileAttachment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FileAttachment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FileAttachment> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public FileAttachment delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this FileAttachment with a source
     *
     * @param sourceFileAttachment the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FileAttachment> patchAsync(@Nonnull final FileAttachment sourceFileAttachment) {
        return sendAsync(HttpMethod.PATCH, sourceFileAttachment);
    }

    /**
     * Patches this FileAttachment with a source
     *
     * @param sourceFileAttachment the source object with updates
     * @return the updated FileAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FileAttachment patch(@Nonnull final FileAttachment sourceFileAttachment) throws ClientException {
        return send(HttpMethod.PATCH, sourceFileAttachment);
    }

    /**
     * Creates a FileAttachment with a new object
     *
     * @param newFileAttachment the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FileAttachment> postAsync(@Nonnull final FileAttachment newFileAttachment) {
        return sendAsync(HttpMethod.POST, newFileAttachment);
    }

    /**
     * Creates a FileAttachment with a new object
     *
     * @param newFileAttachment the new object to create
     * @return the created FileAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FileAttachment post(@Nonnull final FileAttachment newFileAttachment) throws ClientException {
        return send(HttpMethod.POST, newFileAttachment);
    }

    /**
     * Creates a FileAttachment with a new object
     *
     * @param newFileAttachment the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FileAttachment> putAsync(@Nonnull final FileAttachment newFileAttachment) {
        return sendAsync(HttpMethod.PUT, newFileAttachment);
    }

    /**
     * Creates a FileAttachment with a new object
     *
     * @param newFileAttachment the object to create/update
     * @return the created FileAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FileAttachment put(@Nonnull final FileAttachment newFileAttachment) throws ClientException {
        return send(HttpMethod.PUT, newFileAttachment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public FileAttachmentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public FileAttachmentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

