// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Approval;
import com.microsoft.graph.models.AccessPackage;
import com.microsoft.graph.models.AccessPackageAssignmentRequest;
import com.microsoft.graph.models.AccessPackageAssignment;
import com.microsoft.graph.models.AccessPackageCatalog;
import com.microsoft.graph.models.ConnectedOrganization;
import com.microsoft.graph.models.EntitlementManagementSettings;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.ApprovalCollectionPage;
import com.microsoft.graph.requests.AccessPackageCollectionPage;
import com.microsoft.graph.requests.AccessPackageAssignmentRequestCollectionPage;
import com.microsoft.graph.requests.AccessPackageAssignmentCollectionPage;
import com.microsoft.graph.requests.AccessPackageCatalogCollectionPage;
import com.microsoft.graph.requests.ConnectedOrganizationCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Entitlement Management.
 */
public class EntitlementManagement extends Entity implements IJsonBackedObject {


    /**
     * The Access Package Assignment Approvals.
     * 
     */
    @SerializedName(value = "accessPackageAssignmentApprovals", alternate = {"AccessPackageAssignmentApprovals"})
    @Expose
	@Nullable
    public ApprovalCollectionPage accessPackageAssignmentApprovals;

    /**
     * The Access Packages.
     * Access packages.
     */
    @SerializedName(value = "accessPackages", alternate = {"AccessPackages"})
    @Expose
	@Nullable
    public AccessPackageCollectionPage accessPackages;

    /**
     * The Assignment Requests.
     * Access package assignment requests.
     */
    @SerializedName(value = "assignmentRequests", alternate = {"AssignmentRequests"})
    @Expose
	@Nullable
    public AccessPackageAssignmentRequestCollectionPage assignmentRequests;

    /**
     * The Assignments.
     * Access package assignments.
     */
    @SerializedName(value = "assignments", alternate = {"Assignments"})
    @Expose
	@Nullable
    public AccessPackageAssignmentCollectionPage assignments;

    /**
     * The Catalogs.
     * Access package catalogs.
     */
    @SerializedName(value = "catalogs", alternate = {"Catalogs"})
    @Expose
	@Nullable
    public AccessPackageCatalogCollectionPage catalogs;

    /**
     * The Connected Organizations.
     * Connected organizations.
     */
    @SerializedName(value = "connectedOrganizations", alternate = {"ConnectedOrganizations"})
    @Expose
	@Nullable
    public ConnectedOrganizationCollectionPage connectedOrganizations;

    /**
     * The Settings.
     * Entitlement management settings.
     */
    @SerializedName(value = "settings", alternate = {"Settings"})
    @Expose
	@Nullable
    public EntitlementManagementSettings settings;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("accessPackageAssignmentApprovals")) {
            accessPackageAssignmentApprovals = serializer.deserializeObject(json.get("accessPackageAssignmentApprovals"), ApprovalCollectionPage.class);
        }

        if (json.has("accessPackages")) {
            accessPackages = serializer.deserializeObject(json.get("accessPackages"), AccessPackageCollectionPage.class);
        }

        if (json.has("assignmentRequests")) {
            assignmentRequests = serializer.deserializeObject(json.get("assignmentRequests"), AccessPackageAssignmentRequestCollectionPage.class);
        }

        if (json.has("assignments")) {
            assignments = serializer.deserializeObject(json.get("assignments"), AccessPackageAssignmentCollectionPage.class);
        }

        if (json.has("catalogs")) {
            catalogs = serializer.deserializeObject(json.get("catalogs"), AccessPackageCatalogCollectionPage.class);
        }

        if (json.has("connectedOrganizations")) {
            connectedOrganizations = serializer.deserializeObject(json.get("connectedOrganizations"), ConnectedOrganizationCollectionPage.class);
        }
    }
}
