/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.Subdomain;
import com.microsoft.graph.security.requests.SubdomainCollectionPage;
import com.microsoft.graph.security.requests.SubdomainCollectionRequestBuilder;
import com.microsoft.graph.security.requests.SubdomainCollectionResponse;
import com.microsoft.graph.security.requests.SubdomainRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SubdomainCollectionRequest
extends BaseEntityCollectionRequest<Subdomain, SubdomainCollectionResponse, SubdomainCollectionPage> {
    public SubdomainCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SubdomainCollectionResponse.class, SubdomainCollectionPage.class, SubdomainCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Subdomain> postAsync(@Nonnull Subdomain newSubdomain) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SubdomainRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newSubdomain);
    }

    @Nonnull
    public Subdomain post(@Nonnull Subdomain newSubdomain) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SubdomainRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSubdomain);
    }

    @Nonnull
    public SubdomainCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public SubdomainCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public SubdomainCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public SubdomainCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SubdomainCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public SubdomainCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public SubdomainCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public SubdomainCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public SubdomainCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

