/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.VirtualEvent;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.VirtualEventCollectionPage;
import com.microsoft.graph.requests.VirtualEventCollectionRequestBuilder;
import com.microsoft.graph.requests.VirtualEventCollectionResponse;
import com.microsoft.graph.requests.VirtualEventRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VirtualEventCollectionRequest
extends BaseEntityCollectionRequest<VirtualEvent, VirtualEventCollectionResponse, VirtualEventCollectionPage> {
    public VirtualEventCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, VirtualEventCollectionResponse.class, VirtualEventCollectionPage.class, VirtualEventCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<VirtualEvent> postAsync(@Nonnull VirtualEvent newVirtualEvent) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new VirtualEventRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newVirtualEvent);
    }

    @Nonnull
    public VirtualEvent post(@Nonnull VirtualEvent newVirtualEvent) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new VirtualEventRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newVirtualEvent);
    }

    @Nonnull
    public VirtualEventCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public VirtualEventCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public VirtualEventCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public VirtualEventCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public VirtualEventCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public VirtualEventCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public VirtualEventCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public VirtualEventCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public VirtualEventCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

