// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Domain;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.DomainForceDeleteParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Domain Request Builder.
 */
public class DomainRequestBuilder extends BaseRequestBuilder<Domain> {

    /**
     * The request builder for the Domain
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DomainRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the DomainRequest instance
     */
    @Nonnull
    public DomainRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the DomainRequest instance
     */
    @Nonnull
    public DomainRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.DomainRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the DirectoryObject collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.DirectoryObjectCollectionWithReferencesRequestBuilder domainNameReferences() {
        return new com.microsoft.graph.requests.DirectoryObjectCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("domainNameReferences"), getClient(), null);
    }

    /**
     * Gets a request builder for the DirectoryObject item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.DirectoryObjectWithReferenceRequestBuilder domainNameReferences(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DirectoryObjectWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("domainNameReferences") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the InternalDomainFederation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.InternalDomainFederationCollectionRequestBuilder federationConfiguration() {
        return new com.microsoft.graph.requests.InternalDomainFederationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("federationConfiguration"), getClient(), null);
    }

    /**
     * Gets a request builder for the InternalDomainFederation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.InternalDomainFederationRequestBuilder federationConfiguration(@Nonnull final String id) {
        return new com.microsoft.graph.requests.InternalDomainFederationRequestBuilder(getRequestUrlWithAdditionalSegment("federationConfiguration") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the DomainDnsRecord collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.DomainDnsRecordCollectionRequestBuilder serviceConfigurationRecords() {
        return new com.microsoft.graph.requests.DomainDnsRecordCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("serviceConfigurationRecords"), getClient(), null);
    }

    /**
     * Gets a request builder for the DomainDnsRecord item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.DomainDnsRecordRequestBuilder serviceConfigurationRecords(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DomainDnsRecordRequestBuilder(getRequestUrlWithAdditionalSegment("serviceConfigurationRecords") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the DomainDnsRecord collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.DomainDnsRecordCollectionRequestBuilder verificationDnsRecords() {
        return new com.microsoft.graph.requests.DomainDnsRecordCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("verificationDnsRecords"), getClient(), null);
    }

    /**
     * Gets a request builder for the DomainDnsRecord item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.DomainDnsRecordRequestBuilder verificationDnsRecords(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DomainDnsRecordRequestBuilder(getRequestUrlWithAdditionalSegment("verificationDnsRecords") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public DomainForceDeleteRequestBuilder forceDelete(@Nonnull final DomainForceDeleteParameterSet parameters) {
        return new DomainForceDeleteRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.forceDelete"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public DomainPromoteRequestBuilder promote() {
        return new DomainPromoteRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.promote"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public DomainVerifyRequestBuilder verify() {
        return new DomainVerifyRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.verify"), getClient(), null);
    }
}
