// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.OutlierContainerType;
import com.microsoft.graph.models.OutlierMemberType;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.GovernanceInsight;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Membership Outlier Insight.
 */
public class MembershipOutlierInsight extends GovernanceInsight implements IJsonBackedObject {


    /**
     * The Container Id.
     * Indicates the identifier of the container, for example, a group ID.
     */
    @SerializedName(value = "containerId", alternate = {"ContainerId"})
    @Expose
	@Nullable
    public String containerId;

    /**
     * The Member Id.
     * Indicates the identifier of the user.
     */
    @SerializedName(value = "memberId", alternate = {"MemberId"})
    @Expose
	@Nullable
    public String memberId;

    /**
     * The Outlier Container Type.
     * Indicates the type of container. The possible values are: group, unknownFutureValue.
     */
    @SerializedName(value = "outlierContainerType", alternate = {"OutlierContainerType"})
    @Expose
	@Nullable
    public OutlierContainerType outlierContainerType;

    /**
     * The Outlier Member Type.
     * Indicates the type of outlier member. The possible values are: user, unknownFutureValue.
     */
    @SerializedName(value = "outlierMemberType", alternate = {"OutlierMemberType"})
    @Expose
	@Nullable
    public OutlierMemberType outlierMemberType;

    /**
     * The Container.
     * Navigation link to the container directory object. For example, to a group.
     */
    @SerializedName(value = "container", alternate = {"Container"})
    @Expose
	@Nullable
    public DirectoryObject container;

    /**
     * The Last Modified By.
     * Navigation link to a member object who modified the record. For example, to a user.
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public User lastModifiedBy;

    /**
     * The Member.
     * Navigation link to a member object. For example, to a user.
     */
    @SerializedName(value = "member", alternate = {"Member"})
    @Expose
	@Nullable
    public DirectoryObject member;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
