// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.User;
import com.microsoft.graph.identitygovernance.models.Task;
import com.microsoft.graph.identitygovernance.models.TaskProcessingResult;
import com.microsoft.graph.identitygovernance.models.Workflow;
import com.microsoft.graph.models.CustomExtensionData;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Custom Task Extension Callout Data.
 */
public class CustomTaskExtensionCalloutData extends CustomExtensionData implements IJsonBackedObject {


    /**
     * The Subject.
     * 
     */
    @SerializedName(value = "subject", alternate = {"Subject"})
    @Expose
	@Nullable
    public User subject;

    /**
     * The Task.
     * 
     */
    @SerializedName(value = "task", alternate = {"Task"})
    @Expose
	@Nullable
    public Task task;

    /**
     * The Task Processingresult.
     * 
     */
    @SerializedName(value = "taskProcessingresult", alternate = {"TaskProcessingresult"})
    @Expose
	@Nullable
    public TaskProcessingResult taskProcessingresult;

    /**
     * The Workflow.
     * 
     */
    @SerializedName(value = "workflow", alternate = {"Workflow"})
    @Expose
	@Nullable
    public Workflow workflow;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
