// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessReviewSet;
import com.microsoft.graph.requests.AccessReviewScheduleDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.AccessReviewScheduleDefinitionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review Set Request.
 */
public class AccessReviewSetRequest extends BaseRequest<AccessReviewSet> {
	
    /**
     * The request for the AccessReviewSet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessReviewSetRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessReviewSet.class);
    }

    /**
     * Gets the AccessReviewSet from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewSet> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessReviewSet from the service
     *
     * @return the AccessReviewSet from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewSet get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewSet> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessReviewSet delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessReviewSet with a source
     *
     * @param sourceAccessReviewSet the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewSet> patchAsync(@Nonnull final AccessReviewSet sourceAccessReviewSet) {
        return sendAsync(HttpMethod.PATCH, sourceAccessReviewSet);
    }

    /**
     * Patches this AccessReviewSet with a source
     *
     * @param sourceAccessReviewSet the source object with updates
     * @return the updated AccessReviewSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewSet patch(@Nonnull final AccessReviewSet sourceAccessReviewSet) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessReviewSet);
    }

    /**
     * Creates a AccessReviewSet with a new object
     *
     * @param newAccessReviewSet the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewSet> postAsync(@Nonnull final AccessReviewSet newAccessReviewSet) {
        return sendAsync(HttpMethod.POST, newAccessReviewSet);
    }

    /**
     * Creates a AccessReviewSet with a new object
     *
     * @param newAccessReviewSet the new object to create
     * @return the created AccessReviewSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewSet post(@Nonnull final AccessReviewSet newAccessReviewSet) throws ClientException {
        return send(HttpMethod.POST, newAccessReviewSet);
    }

    /**
     * Creates a AccessReviewSet with a new object
     *
     * @param newAccessReviewSet the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewSet> putAsync(@Nonnull final AccessReviewSet newAccessReviewSet) {
        return sendAsync(HttpMethod.PUT, newAccessReviewSet);
    }

    /**
     * Creates a AccessReviewSet with a new object
     *
     * @param newAccessReviewSet the object to create/update
     * @return the created AccessReviewSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewSet put(@Nonnull final AccessReviewSet newAccessReviewSet) throws ClientException {
        return send(HttpMethod.PUT, newAccessReviewSet);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessReviewSetRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessReviewSetRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

