// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WindowsMobileMSI;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Mobile MSIRequest.
 */
public class WindowsMobileMSIRequest extends BaseRequest<WindowsMobileMSI> {
	
    /**
     * The request for the WindowsMobileMSI
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsMobileMSIRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsMobileMSI.class);
    }

    /**
     * Gets the WindowsMobileMSI from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMobileMSI> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WindowsMobileMSI from the service
     *
     * @return the WindowsMobileMSI from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMobileMSI get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMobileMSI> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WindowsMobileMSI delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsMobileMSI with a source
     *
     * @param sourceWindowsMobileMSI the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMobileMSI> patchAsync(@Nonnull final WindowsMobileMSI sourceWindowsMobileMSI) {
        return sendAsync(HttpMethod.PATCH, sourceWindowsMobileMSI);
    }

    /**
     * Patches this WindowsMobileMSI with a source
     *
     * @param sourceWindowsMobileMSI the source object with updates
     * @return the updated WindowsMobileMSI
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMobileMSI patch(@Nonnull final WindowsMobileMSI sourceWindowsMobileMSI) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsMobileMSI);
    }

    /**
     * Creates a WindowsMobileMSI with a new object
     *
     * @param newWindowsMobileMSI the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMobileMSI> postAsync(@Nonnull final WindowsMobileMSI newWindowsMobileMSI) {
        return sendAsync(HttpMethod.POST, newWindowsMobileMSI);
    }

    /**
     * Creates a WindowsMobileMSI with a new object
     *
     * @param newWindowsMobileMSI the new object to create
     * @return the created WindowsMobileMSI
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMobileMSI post(@Nonnull final WindowsMobileMSI newWindowsMobileMSI) throws ClientException {
        return send(HttpMethod.POST, newWindowsMobileMSI);
    }

    /**
     * Creates a WindowsMobileMSI with a new object
     *
     * @param newWindowsMobileMSI the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsMobileMSI> putAsync(@Nonnull final WindowsMobileMSI newWindowsMobileMSI) {
        return sendAsync(HttpMethod.PUT, newWindowsMobileMSI);
    }

    /**
     * Creates a WindowsMobileMSI with a new object
     *
     * @param newWindowsMobileMSI the object to create/update
     * @return the created WindowsMobileMSI
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsMobileMSI put(@Nonnull final WindowsMobileMSI newWindowsMobileMSI) throws ClientException {
        return send(HttpMethod.PUT, newWindowsMobileMSI);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WindowsMobileMSIRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WindowsMobileMSIRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

