// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.VirtualEndpoint;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Endpoint Request.
 */
public class VirtualEndpointRequest extends BaseRequest<VirtualEndpoint> {
	
    /**
     * The request for the VirtualEndpoint
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public VirtualEndpointRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, VirtualEndpoint.class);
    }

    /**
     * Gets the VirtualEndpoint from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEndpoint> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the VirtualEndpoint from the service
     *
     * @return the VirtualEndpoint from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEndpoint get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEndpoint> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public VirtualEndpoint delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this VirtualEndpoint with a source
     *
     * @param sourceVirtualEndpoint the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEndpoint> patchAsync(@Nonnull final VirtualEndpoint sourceVirtualEndpoint) {
        return sendAsync(HttpMethod.PATCH, sourceVirtualEndpoint);
    }

    /**
     * Patches this VirtualEndpoint with a source
     *
     * @param sourceVirtualEndpoint the source object with updates
     * @return the updated VirtualEndpoint
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEndpoint patch(@Nonnull final VirtualEndpoint sourceVirtualEndpoint) throws ClientException {
        return send(HttpMethod.PATCH, sourceVirtualEndpoint);
    }

    /**
     * Creates a VirtualEndpoint with a new object
     *
     * @param newVirtualEndpoint the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEndpoint> postAsync(@Nonnull final VirtualEndpoint newVirtualEndpoint) {
        return sendAsync(HttpMethod.POST, newVirtualEndpoint);
    }

    /**
     * Creates a VirtualEndpoint with a new object
     *
     * @param newVirtualEndpoint the new object to create
     * @return the created VirtualEndpoint
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEndpoint post(@Nonnull final VirtualEndpoint newVirtualEndpoint) throws ClientException {
        return send(HttpMethod.POST, newVirtualEndpoint);
    }

    /**
     * Creates a VirtualEndpoint with a new object
     *
     * @param newVirtualEndpoint the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEndpoint> putAsync(@Nonnull final VirtualEndpoint newVirtualEndpoint) {
        return sendAsync(HttpMethod.PUT, newVirtualEndpoint);
    }

    /**
     * Creates a VirtualEndpoint with a new object
     *
     * @param newVirtualEndpoint the object to create/update
     * @return the created VirtualEndpoint
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEndpoint put(@Nonnull final VirtualEndpoint newVirtualEndpoint) throws ClientException {
        return send(HttpMethod.PUT, newVirtualEndpoint);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public VirtualEndpointRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public VirtualEndpointRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

