// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SolutionsRoot;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Solutions Root Request Builder.
 */
public class SolutionsRootRequestBuilder extends BaseRequestBuilder<SolutionsRoot> {

    /**
     * The request builder for the SolutionsRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SolutionsRootRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the SolutionsRootRequest instance
     */
    @Nonnull
    public SolutionsRootRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the SolutionsRootRequest instance
     */
    @Nonnull
    public SolutionsRootRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.SolutionsRootRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the BookingBusiness collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingBusinessCollectionRequestBuilder bookingBusinesses() {
        return new com.microsoft.graph.requests.BookingBusinessCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("bookingBusinesses"), getClient(), null);
    }

    /**
     * Gets a request builder for the BookingBusiness item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingBusinessRequestBuilder bookingBusinesses(@Nonnull final String id) {
        return new com.microsoft.graph.requests.BookingBusinessRequestBuilder(getRequestUrlWithAdditionalSegment("bookingBusinesses") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the BookingCurrency collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingCurrencyCollectionRequestBuilder bookingCurrencies() {
        return new com.microsoft.graph.requests.BookingCurrencyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("bookingCurrencies"), getClient(), null);
    }

    /**
     * Gets a request builder for the BookingCurrency item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.BookingCurrencyRequestBuilder bookingCurrencies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.BookingCurrencyRequestBuilder(getRequestUrlWithAdditionalSegment("bookingCurrencies") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for VirtualEventsRoot
     *
     * @return the VirtualEventsRootRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.VirtualEventsRootRequestBuilder virtualEvents() {
        return new com.microsoft.graph.requests.VirtualEventsRootRequestBuilder(getRequestUrlWithAdditionalSegment("virtualEvents"), getClient(), null);
    }
}
