// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.SynchronizationJobRestartCriteria;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Job Restart Parameter Set.
 */
public class SynchronizationJobRestartParameterSet {
    /**
     * The criteria.
     * 
     */
    @SerializedName(value = "criteria", alternate = {"Criteria"})
    @Expose
	@Nullable
    public SynchronizationJobRestartCriteria criteria;


    /**
     * Instiaciates a new SynchronizationJobRestartParameterSet
     */
    public SynchronizationJobRestartParameterSet() {}
    /**
     * Instiaciates a new SynchronizationJobRestartParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected SynchronizationJobRestartParameterSet(@Nonnull final SynchronizationJobRestartParameterSetBuilder builder) {
        this.criteria = builder.criteria;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static SynchronizationJobRestartParameterSetBuilder newBuilder() {
        return new SynchronizationJobRestartParameterSetBuilder();
    }
    /**
     * Fluent builder for the SynchronizationJobRestartParameterSet
     */
    public static final class SynchronizationJobRestartParameterSetBuilder {
        /**
         * The criteria parameter value
         */
        @Nullable
        protected SynchronizationJobRestartCriteria criteria;
        /**
         * Sets the Criteria
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public SynchronizationJobRestartParameterSetBuilder withCriteria(@Nullable final SynchronizationJobRestartCriteria val) {
            this.criteria = val;
            return this;
        }
        /**
         * Instanciates a new SynchronizationJobRestartParameterSetBuilder
         */
        @Nullable
        protected SynchronizationJobRestartParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public SynchronizationJobRestartParameterSet build() {
            return new SynchronizationJobRestartParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.criteria != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("criteria", criteria));
        }
        return result;
    }
}
