// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Report;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Report Root Managed Device Enrollment Failure Details Parameter Set.
 */
public class ReportRootManagedDeviceEnrollmentFailureDetailsParameterSet {
    /**
     * The skip.
     * 
     */
    @SerializedName(value = "skip", alternate = {"Skip"})
    @Expose
	@Nullable
    public Integer skip;

    /**
     * The top.
     * 
     */
    @SerializedName(value = "top", alternate = {"Top"})
    @Expose
	@Nullable
    public Integer top;

    /**
     * The filter.
     * 
     */
    @SerializedName(value = "filter", alternate = {"Filter"})
    @Expose
	@Nullable
    public String filter;

    /**
     * The skip Token.
     * 
     */
    @SerializedName(value = "skipToken", alternate = {"SkipToken"})
    @Expose
	@Nullable
    public String skipToken;


    /**
     * Instiaciates a new ReportRootManagedDeviceEnrollmentFailureDetailsParameterSet
     */
    public ReportRootManagedDeviceEnrollmentFailureDetailsParameterSet() {}
    /**
     * Instiaciates a new ReportRootManagedDeviceEnrollmentFailureDetailsParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ReportRootManagedDeviceEnrollmentFailureDetailsParameterSet(@Nonnull final ReportRootManagedDeviceEnrollmentFailureDetailsParameterSetBuilder builder) {
        this.skip = builder.skip;
        this.top = builder.top;
        this.filter = builder.filter;
        this.skipToken = builder.skipToken;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ReportRootManagedDeviceEnrollmentFailureDetailsParameterSetBuilder newBuilder() {
        return new ReportRootManagedDeviceEnrollmentFailureDetailsParameterSetBuilder();
    }
    /**
     * Fluent builder for the ReportRootManagedDeviceEnrollmentFailureDetailsParameterSet
     */
    public static final class ReportRootManagedDeviceEnrollmentFailureDetailsParameterSetBuilder {
        /**
         * The skip parameter value
         */
        @Nullable
        protected Integer skip;
        /**
         * Sets the Skip
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ReportRootManagedDeviceEnrollmentFailureDetailsParameterSetBuilder withSkip(@Nullable final Integer val) {
            this.skip = val;
            return this;
        }
        /**
         * The top parameter value
         */
        @Nullable
        protected Integer top;
        /**
         * Sets the Top
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ReportRootManagedDeviceEnrollmentFailureDetailsParameterSetBuilder withTop(@Nullable final Integer val) {
            this.top = val;
            return this;
        }
        /**
         * The filter parameter value
         */
        @Nullable
        protected String filter;
        /**
         * Sets the Filter
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ReportRootManagedDeviceEnrollmentFailureDetailsParameterSetBuilder withFilter(@Nullable final String val) {
            this.filter = val;
            return this;
        }
        /**
         * The skipToken parameter value
         */
        @Nullable
        protected String skipToken;
        /**
         * Sets the SkipToken
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ReportRootManagedDeviceEnrollmentFailureDetailsParameterSetBuilder withSkipToken(@Nullable final String val) {
            this.skipToken = val;
            return this;
        }
        /**
         * Instanciates a new ReportRootManagedDeviceEnrollmentFailureDetailsParameterSetBuilder
         */
        @Nullable
        protected ReportRootManagedDeviceEnrollmentFailureDetailsParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ReportRootManagedDeviceEnrollmentFailureDetailsParameterSet build() {
            return new ReportRootManagedDeviceEnrollmentFailureDetailsParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.skip != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("skip", skip));
        }
        if(this.top != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("top", top));
        }
        if(this.filter != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("filter", filter));
        }
        if(this.skipToken != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("skipToken", skipToken));
        }
        return result;
    }
}
