// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;
import com.microsoft.graph.identitygovernance.requests.WorkflowRestoreRequest;
import com.microsoft.graph.identitygovernance.models.Workflow;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workflow Restore Request Builder.
 */
public class WorkflowRestoreRequestBuilder extends BaseActionRequestBuilder<Workflow> {

    /**
     * The request builder for this WorkflowRestore
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkflowRestoreRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the WorkflowRestoreRequest
     *
     * @param requestOptions the options for the request
     * @return the WorkflowRestoreRequest instance
     */
    @Nonnull
    public WorkflowRestoreRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the WorkflowRestoreRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the WorkflowRestoreRequest instance
     */
    @Nonnull
    public WorkflowRestoreRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final WorkflowRestoreRequest request = new WorkflowRestoreRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
