// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.HostReputationClassification;
import com.microsoft.graph.security.models.HostReputationRule;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Reputation.
 */
public class HostReputation extends Entity implements IJsonBackedObject {


    /**
     * The Classification.
     * The calculated reputation of the host. The possible values are: unknown, neutral, suspicious, malicious, unknownFutureValue.
     */
    @SerializedName(value = "classification", alternate = {"Classification"})
    @Expose
	@Nullable
    public HostReputationClassification classification;

    /**
     * The Rules.
     * A collection of rules that have been used to calculate the classification and score.
     */
    @SerializedName(value = "rules", alternate = {"Rules"})
    @Expose
	@Nullable
    public java.util.List<HostReputationRule> rules;

    /**
     * The Score.
     * The calculated score (0-100) of the requested host. A higher value indicates that this host is more likely to be suspicious or malicious.
     */
    @SerializedName(value = "score", alternate = {"Score"})
    @Expose
	@Nullable
    public Integer score;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
