// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.ContainerImageEvidence;
import com.microsoft.graph.security.models.ContainerRegistryEvidence;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Container Image Evidence.
 */
public class ContainerImageEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Digest Image.
     * The digest image entity, in case this is a tag image.
     */
    @SerializedName(value = "digestImage", alternate = {"DigestImage"})
    @Expose
	@Nullable
    public ContainerImageEvidence digestImage;

    /**
     * The Image Id.
     * The unique identifier for the container image entity.
     */
    @SerializedName(value = "imageId", alternate = {"ImageId"})
    @Expose
	@Nullable
    public String imageId;

    /**
     * The Registry.
     * The container registry for this image.
     */
    @SerializedName(value = "registry", alternate = {"Registry"})
    @Expose
	@Nullable
    public ContainerRegistryEvidence registry;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
