// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.VirtualEventRegistration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Event Registration Request.
 */
public class VirtualEventRegistrationRequest extends BaseRequest<VirtualEventRegistration> {
	
    /**
     * The request for the VirtualEventRegistration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public VirtualEventRegistrationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, VirtualEventRegistration.class);
    }

    /**
     * Gets the VirtualEventRegistration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventRegistration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the VirtualEventRegistration from the service
     *
     * @return the VirtualEventRegistration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventRegistration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventRegistration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public VirtualEventRegistration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this VirtualEventRegistration with a source
     *
     * @param sourceVirtualEventRegistration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventRegistration> patchAsync(@Nonnull final VirtualEventRegistration sourceVirtualEventRegistration) {
        return sendAsync(HttpMethod.PATCH, sourceVirtualEventRegistration);
    }

    /**
     * Patches this VirtualEventRegistration with a source
     *
     * @param sourceVirtualEventRegistration the source object with updates
     * @return the updated VirtualEventRegistration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventRegistration patch(@Nonnull final VirtualEventRegistration sourceVirtualEventRegistration) throws ClientException {
        return send(HttpMethod.PATCH, sourceVirtualEventRegistration);
    }

    /**
     * Creates a VirtualEventRegistration with a new object
     *
     * @param newVirtualEventRegistration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventRegistration> postAsync(@Nonnull final VirtualEventRegistration newVirtualEventRegistration) {
        return sendAsync(HttpMethod.POST, newVirtualEventRegistration);
    }

    /**
     * Creates a VirtualEventRegistration with a new object
     *
     * @param newVirtualEventRegistration the new object to create
     * @return the created VirtualEventRegistration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventRegistration post(@Nonnull final VirtualEventRegistration newVirtualEventRegistration) throws ClientException {
        return send(HttpMethod.POST, newVirtualEventRegistration);
    }

    /**
     * Creates a VirtualEventRegistration with a new object
     *
     * @param newVirtualEventRegistration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VirtualEventRegistration> putAsync(@Nonnull final VirtualEventRegistration newVirtualEventRegistration) {
        return sendAsync(HttpMethod.PUT, newVirtualEventRegistration);
    }

    /**
     * Creates a VirtualEventRegistration with a new object
     *
     * @param newVirtualEventRegistration the object to create/update
     * @return the created VirtualEventRegistration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VirtualEventRegistration put(@Nonnull final VirtualEventRegistration newVirtualEventRegistration) throws ClientException {
        return send(HttpMethod.PUT, newVirtualEventRegistration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public VirtualEventRegistrationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public VirtualEventRegistrationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

