// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PeopleAdminSettings;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the People Admin Settings Request.
 */
public class PeopleAdminSettingsRequest extends BaseRequest<PeopleAdminSettings> {
	
    /**
     * The request for the PeopleAdminSettings
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PeopleAdminSettingsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PeopleAdminSettings.class);
    }

    /**
     * Gets the PeopleAdminSettings from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PeopleAdminSettings> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PeopleAdminSettings from the service
     *
     * @return the PeopleAdminSettings from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PeopleAdminSettings get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PeopleAdminSettings> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PeopleAdminSettings delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PeopleAdminSettings with a source
     *
     * @param sourcePeopleAdminSettings the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PeopleAdminSettings> patchAsync(@Nonnull final PeopleAdminSettings sourcePeopleAdminSettings) {
        return sendAsync(HttpMethod.PATCH, sourcePeopleAdminSettings);
    }

    /**
     * Patches this PeopleAdminSettings with a source
     *
     * @param sourcePeopleAdminSettings the source object with updates
     * @return the updated PeopleAdminSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PeopleAdminSettings patch(@Nonnull final PeopleAdminSettings sourcePeopleAdminSettings) throws ClientException {
        return send(HttpMethod.PATCH, sourcePeopleAdminSettings);
    }

    /**
     * Creates a PeopleAdminSettings with a new object
     *
     * @param newPeopleAdminSettings the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PeopleAdminSettings> postAsync(@Nonnull final PeopleAdminSettings newPeopleAdminSettings) {
        return sendAsync(HttpMethod.POST, newPeopleAdminSettings);
    }

    /**
     * Creates a PeopleAdminSettings with a new object
     *
     * @param newPeopleAdminSettings the new object to create
     * @return the created PeopleAdminSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PeopleAdminSettings post(@Nonnull final PeopleAdminSettings newPeopleAdminSettings) throws ClientException {
        return send(HttpMethod.POST, newPeopleAdminSettings);
    }

    /**
     * Creates a PeopleAdminSettings with a new object
     *
     * @param newPeopleAdminSettings the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PeopleAdminSettings> putAsync(@Nonnull final PeopleAdminSettings newPeopleAdminSettings) {
        return sendAsync(HttpMethod.PUT, newPeopleAdminSettings);
    }

    /**
     * Creates a PeopleAdminSettings with a new object
     *
     * @param newPeopleAdminSettings the object to create/update
     * @return the created PeopleAdminSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PeopleAdminSettings put(@Nonnull final PeopleAdminSettings newPeopleAdminSettings) throws ClientException {
        return send(HttpMethod.PUT, newPeopleAdminSettings);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PeopleAdminSettingsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PeopleAdminSettingsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

