// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MembershipOutlierInsight;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Membership Outlier Insight Request.
 */
public class MembershipOutlierInsightRequest extends BaseRequest<MembershipOutlierInsight> {
	
    /**
     * The request for the MembershipOutlierInsight
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MembershipOutlierInsightRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MembershipOutlierInsight.class);
    }

    /**
     * Gets the MembershipOutlierInsight from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MembershipOutlierInsight> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MembershipOutlierInsight from the service
     *
     * @return the MembershipOutlierInsight from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MembershipOutlierInsight get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MembershipOutlierInsight> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MembershipOutlierInsight delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MembershipOutlierInsight with a source
     *
     * @param sourceMembershipOutlierInsight the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MembershipOutlierInsight> patchAsync(@Nonnull final MembershipOutlierInsight sourceMembershipOutlierInsight) {
        return sendAsync(HttpMethod.PATCH, sourceMembershipOutlierInsight);
    }

    /**
     * Patches this MembershipOutlierInsight with a source
     *
     * @param sourceMembershipOutlierInsight the source object with updates
     * @return the updated MembershipOutlierInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MembershipOutlierInsight patch(@Nonnull final MembershipOutlierInsight sourceMembershipOutlierInsight) throws ClientException {
        return send(HttpMethod.PATCH, sourceMembershipOutlierInsight);
    }

    /**
     * Creates a MembershipOutlierInsight with a new object
     *
     * @param newMembershipOutlierInsight the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MembershipOutlierInsight> postAsync(@Nonnull final MembershipOutlierInsight newMembershipOutlierInsight) {
        return sendAsync(HttpMethod.POST, newMembershipOutlierInsight);
    }

    /**
     * Creates a MembershipOutlierInsight with a new object
     *
     * @param newMembershipOutlierInsight the new object to create
     * @return the created MembershipOutlierInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MembershipOutlierInsight post(@Nonnull final MembershipOutlierInsight newMembershipOutlierInsight) throws ClientException {
        return send(HttpMethod.POST, newMembershipOutlierInsight);
    }

    /**
     * Creates a MembershipOutlierInsight with a new object
     *
     * @param newMembershipOutlierInsight the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MembershipOutlierInsight> putAsync(@Nonnull final MembershipOutlierInsight newMembershipOutlierInsight) {
        return sendAsync(HttpMethod.PUT, newMembershipOutlierInsight);
    }

    /**
     * Creates a MembershipOutlierInsight with a new object
     *
     * @param newMembershipOutlierInsight the object to create/update
     * @return the created MembershipOutlierInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MembershipOutlierInsight put(@Nonnull final MembershipOutlierInsight newMembershipOutlierInsight) throws ClientException {
        return send(HttpMethod.PUT, newMembershipOutlierInsight);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MembershipOutlierInsightRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MembershipOutlierInsightRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

