// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ItemAttachment;
import com.microsoft.graph.models.AttachmentItem;
import com.microsoft.graph.models.UploadSession;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Attachment Request.
 */
public class ItemAttachmentRequest extends BaseRequest<ItemAttachment> {
	
    /**
     * The request for the ItemAttachment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ItemAttachmentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemAttachment.class);
    }

    /**
     * Gets the ItemAttachment from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemAttachment> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ItemAttachment from the service
     *
     * @return the ItemAttachment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemAttachment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemAttachment> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ItemAttachment delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ItemAttachment with a source
     *
     * @param sourceItemAttachment the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemAttachment> patchAsync(@Nonnull final ItemAttachment sourceItemAttachment) {
        return sendAsync(HttpMethod.PATCH, sourceItemAttachment);
    }

    /**
     * Patches this ItemAttachment with a source
     *
     * @param sourceItemAttachment the source object with updates
     * @return the updated ItemAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemAttachment patch(@Nonnull final ItemAttachment sourceItemAttachment) throws ClientException {
        return send(HttpMethod.PATCH, sourceItemAttachment);
    }

    /**
     * Creates a ItemAttachment with a new object
     *
     * @param newItemAttachment the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemAttachment> postAsync(@Nonnull final ItemAttachment newItemAttachment) {
        return sendAsync(HttpMethod.POST, newItemAttachment);
    }

    /**
     * Creates a ItemAttachment with a new object
     *
     * @param newItemAttachment the new object to create
     * @return the created ItemAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemAttachment post(@Nonnull final ItemAttachment newItemAttachment) throws ClientException {
        return send(HttpMethod.POST, newItemAttachment);
    }

    /**
     * Creates a ItemAttachment with a new object
     *
     * @param newItemAttachment the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ItemAttachment> putAsync(@Nonnull final ItemAttachment newItemAttachment) {
        return sendAsync(HttpMethod.PUT, newItemAttachment);
    }

    /**
     * Creates a ItemAttachment with a new object
     *
     * @param newItemAttachment the object to create/update
     * @return the created ItemAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ItemAttachment put(@Nonnull final ItemAttachment newItemAttachment) throws ClientException {
        return send(HttpMethod.PUT, newItemAttachment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ItemAttachmentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ItemAttachmentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

