// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.VirtualEventWebinar;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Event Webinar Get By User Id And Role Parameter Set.
 */
public class VirtualEventWebinarGetByUserIdAndRoleParameterSet {
    /**
     * The user Id.
     * 
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
	@Nullable
    public String userId;

    /**
     * The role.
     * 
     */
    @SerializedName(value = "role", alternate = {"Role"})
    @Expose
	@Nullable
    public String role;


    /**
     * Instiaciates a new VirtualEventWebinarGetByUserIdAndRoleParameterSet
     */
    public VirtualEventWebinarGetByUserIdAndRoleParameterSet() {}
    /**
     * Instiaciates a new VirtualEventWebinarGetByUserIdAndRoleParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected VirtualEventWebinarGetByUserIdAndRoleParameterSet(@Nonnull final VirtualEventWebinarGetByUserIdAndRoleParameterSetBuilder builder) {
        this.userId = builder.userId;
        this.role = builder.role;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static VirtualEventWebinarGetByUserIdAndRoleParameterSetBuilder newBuilder() {
        return new VirtualEventWebinarGetByUserIdAndRoleParameterSetBuilder();
    }
    /**
     * Fluent builder for the VirtualEventWebinarGetByUserIdAndRoleParameterSet
     */
    public static final class VirtualEventWebinarGetByUserIdAndRoleParameterSetBuilder {
        /**
         * The userId parameter value
         */
        @Nullable
        protected String userId;
        /**
         * Sets the UserId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public VirtualEventWebinarGetByUserIdAndRoleParameterSetBuilder withUserId(@Nullable final String val) {
            this.userId = val;
            return this;
        }
        /**
         * The role parameter value
         */
        @Nullable
        protected String role;
        /**
         * Sets the Role
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public VirtualEventWebinarGetByUserIdAndRoleParameterSetBuilder withRole(@Nullable final String val) {
            this.role = val;
            return this;
        }
        /**
         * Instanciates a new VirtualEventWebinarGetByUserIdAndRoleParameterSetBuilder
         */
        @Nullable
        protected VirtualEventWebinarGetByUserIdAndRoleParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public VirtualEventWebinarGetByUserIdAndRoleParameterSet build() {
            return new VirtualEventWebinarGetByUserIdAndRoleParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.userId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("userId", userId));
        }
        if(this.role != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("role", role));
        }
        return result;
    }
}
