// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.DelegatedAdminRelationship;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Reseller Delegated Admin Relationship.
 */
public class ResellerDelegatedAdminRelationship extends DelegatedAdminRelationship implements IJsonBackedObject {


    /**
     * The Indirect Provider Tenant Id.
     * The tenant ID of the indirect provider partner who created the relationship for the indirect reseller partner.
     */
    @SerializedName(value = "indirectProviderTenantId", alternate = {"IndirectProviderTenantId"})
    @Expose
	@Nullable
    public String indirectProviderTenantId;

    /**
     * The Is Partner Consent Pending.
     * Indicates the indirect reseller partner consent status. true indicates that the partner has yet to review the relationship; false indicates that the partner has already provided consent by approving or rejecting the relationship.
     */
    @SerializedName(value = "isPartnerConsentPending", alternate = {"IsPartnerConsentPending"})
    @Expose
	@Nullable
    public Boolean isPartnerConsentPending;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
