// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Identity;
import com.microsoft.graph.models.EndpointType;
import com.microsoft.graph.models.IdentitySet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Communications Identity Set.
 */
public class CommunicationsIdentitySet extends IdentitySet implements IJsonBackedObject {


    /**
     * The Application Instance.
     * The application instance associated with this action.
     */
    @SerializedName(value = "applicationInstance", alternate = {"ApplicationInstance"})
    @Expose
	@Nullable
    public Identity applicationInstance;

    /**
     * The Asserted Identity.
     * An identity the participant would like to present itself as to the other participants in the call.
     */
    @SerializedName(value = "assertedIdentity", alternate = {"AssertedIdentity"})
    @Expose
	@Nullable
    public Identity assertedIdentity;

    /**
     * The Azure Communication Services User.
     * The Azure Communication Services user associated with this action.
     */
    @SerializedName(value = "azureCommunicationServicesUser", alternate = {"AzureCommunicationServicesUser"})
    @Expose
	@Nullable
    public Identity azureCommunicationServicesUser;

    /**
     * The Encrypted.
     * The encrypted user associated with this action.
     */
    @SerializedName(value = "encrypted", alternate = {"Encrypted"})
    @Expose
	@Nullable
    public Identity encrypted;

    /**
     * The Endpoint Type.
     * Type of endpoint that the participant uses. Possible values are: default, voicemail, skypeForBusiness, skypeForBusinessVoipPhone, unknownFutureValue.
     */
    @SerializedName(value = "endpointType", alternate = {"EndpointType"})
    @Expose
	@Nullable
    public EndpointType endpointType;

    /**
     * The Guest.
     * The guest user associated with this action.
     */
    @SerializedName(value = "guest", alternate = {"Guest"})
    @Expose
	@Nullable
    public Identity guest;

    /**
     * The On Premises.
     * The Skype for Business on-premises user associated with this action.
     */
    @SerializedName(value = "onPremises", alternate = {"OnPremises"})
    @Expose
	@Nullable
    public Identity onPremises;

    /**
     * The Phone.
     * The phone user associated with this action.
     */
    @SerializedName(value = "phone", alternate = {"Phone"})
    @Expose
	@Nullable
    public Identity phone;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
