// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.callrecords.models.PstnCallDurationSource;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Pstn Call Log Row.
 */
public class PstnCallLogRow implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Call Duration Source.
     * The source of the call duration data. If the call uses a third-party telecommunications operator via the Operator Connect Program, the operator can provide their own call duration data. In this case, the property value is operator. Otherwise, the value is microsoft.
     */
    @SerializedName(value = "callDurationSource", alternate = {"CallDurationSource"})
    @Expose
	@Nullable
    public PstnCallDurationSource callDurationSource;

    /**
     * The Callee Number.
     * Number dialed in E.164 format.
     */
    @SerializedName(value = "calleeNumber", alternate = {"CalleeNumber"})
    @Expose
	@Nullable
    public String calleeNumber;

    /**
     * The Caller Number.
     * Number that received the call for inbound calls or the number dialed for outbound calls. E.164 format.
     */
    @SerializedName(value = "callerNumber", alternate = {"CallerNumber"})
    @Expose
	@Nullable
    public String callerNumber;

    /**
     * The Call Id.
     * Call identifier. Not guaranteed to be unique.
     */
    @SerializedName(value = "callId", alternate = {"CallId"})
    @Expose
	@Nullable
    public String callId;

    /**
     * The Call Type.
     * Indicates whether the call was a PSTN outbound or inbound call and the type of call, such as a call placed by a user or an audio conference.
     */
    @SerializedName(value = "callType", alternate = {"CallType"})
    @Expose
	@Nullable
    public String callType;

    /**
     * The Charge.
     * Amount of money or cost of the call that is charged to your account.
     */
    @SerializedName(value = "charge", alternate = {"Charge"})
    @Expose
	@Nullable
    public java.math.BigDecimal charge;

    /**
     * The Conference Id.
     * ID of the audio conference.
     */
    @SerializedName(value = "conferenceId", alternate = {"ConferenceId"})
    @Expose
	@Nullable
    public String conferenceId;

    /**
     * The Connection Charge.
     * Connection fee price.
     */
    @SerializedName(value = "connectionCharge", alternate = {"ConnectionCharge"})
    @Expose
	@Nullable
    public java.math.BigDecimal connectionCharge;

    /**
     * The Currency.
     * Type of currency used to calculate the cost of the call. For details, see (ISO 4217.
     */
    @SerializedName(value = "currency", alternate = {"Currency"})
    @Expose
	@Nullable
    public String currency;

    /**
     * The Destination Context.
     * Whether the call was domestic (within a country or region) or international (outside a country or region), based on the user's location.
     */
    @SerializedName(value = "destinationContext", alternate = {"DestinationContext"})
    @Expose
	@Nullable
    public String destinationContext;

    /**
     * The Destination Name.
     * Country or region dialed.
     */
    @SerializedName(value = "destinationName", alternate = {"DestinationName"})
    @Expose
	@Nullable
    public String destinationName;

    /**
     * The Duration.
     * How long the call was connected, in seconds.
     */
    @SerializedName(value = "duration", alternate = {"Duration"})
    @Expose
	@Nullable
    public Integer duration;

    /**
     * The End Date Time.
     * Call end time.
     */
    @SerializedName(value = "endDateTime", alternate = {"EndDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime endDateTime;

    /**
     * The Id.
     * Unique call identifier. GUID.
     */
    @SerializedName(value = "id", alternate = {"Id"})
    @Expose
	@Nullable
    public String id;

    /**
     * The Inventory Type.
     * User's phone number type, such as a service of toll-free number.
     */
    @SerializedName(value = "inventoryType", alternate = {"InventoryType"})
    @Expose
	@Nullable
    public String inventoryType;

    /**
     * The License Capability.
     * The license used for the call.
     */
    @SerializedName(value = "licenseCapability", alternate = {"LicenseCapability"})
    @Expose
	@Nullable
    public String licenseCapability;

    /**
     * The Operator.
     * The telecommunications operator which provided PSTN services for this call. This might be Microsoft, or it might be a third-party operator via the Operator Connect Program.
     */
    @SerializedName(value = "operator", alternate = {"Operator"})
    @Expose
	@Nullable
    public String operator;

    /**
     * The Start Date Time.
     * Call start time.
     */
    @SerializedName(value = "startDateTime", alternate = {"StartDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startDateTime;

    /**
     * The Tenant Country Code.
     * Country code of the tenant. For details, see ISO 3166-1 alpha-2.
     */
    @SerializedName(value = "tenantCountryCode", alternate = {"TenantCountryCode"})
    @Expose
	@Nullable
    public String tenantCountryCode;

    /**
     * The Usage Country Code.
     * Country code of the user. For details, see ISO 3166-1 alpha-2.
     */
    @SerializedName(value = "usageCountryCode", alternate = {"UsageCountryCode"})
    @Expose
	@Nullable
    public String usageCountryCode;

    /**
     * The User Display Name.
     * Display name of the user.
     */
    @SerializedName(value = "userDisplayName", alternate = {"UserDisplayName"})
    @Expose
	@Nullable
    public String userDisplayName;

    /**
     * The User Id.
     * Calling user's ID in Microsoft Graph. GUID. This and other user info will be null/empty for bot call types (ucapin, ucapout).
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
	@Nullable
    public String userId;

    /**
     * The User Principal Name.
     * The user principal name (sign-in name) in Microsoft Entra ID. This is usually the same as the user's SIP address, and can be the same as the user's email address.
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
	@Nullable
    public String userPrincipalName;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
