// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.DataSet;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Data Set Request.
 */
public class DataSetRequest extends BaseRequest<DataSet> {
	
    /**
     * The request for the DataSet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public DataSetRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends DataSet> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the DataSet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DataSetRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DataSet.class);
    }

    /**
     * Gets the DataSet from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSet> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DataSet from the service
     *
     * @return the DataSet from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSet get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSet> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DataSet delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DataSet with a source
     *
     * @param sourceDataSet the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSet> patchAsync(@Nonnull final DataSet sourceDataSet) {
        return sendAsync(HttpMethod.PATCH, sourceDataSet);
    }

    /**
     * Patches this DataSet with a source
     *
     * @param sourceDataSet the source object with updates
     * @return the updated DataSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSet patch(@Nonnull final DataSet sourceDataSet) throws ClientException {
        return send(HttpMethod.PATCH, sourceDataSet);
    }

    /**
     * Creates a DataSet with a new object
     *
     * @param newDataSet the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSet> postAsync(@Nonnull final DataSet newDataSet) {
        return sendAsync(HttpMethod.POST, newDataSet);
    }

    /**
     * Creates a DataSet with a new object
     *
     * @param newDataSet the new object to create
     * @return the created DataSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSet post(@Nonnull final DataSet newDataSet) throws ClientException {
        return send(HttpMethod.POST, newDataSet);
    }

    /**
     * Creates a DataSet with a new object
     *
     * @param newDataSet the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSet> putAsync(@Nonnull final DataSet newDataSet) {
        return sendAsync(HttpMethod.PUT, newDataSet);
    }

    /**
     * Creates a DataSet with a new object
     *
     * @param newDataSet the object to create/update
     * @return the created DataSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSet put(@Nonnull final DataSet newDataSet) throws ClientException {
        return send(HttpMethod.PUT, newDataSet);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DataSetRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DataSetRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

