// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.PhysicalAddress;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Whois Contact.
 */
public class WhoisContact implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Address.
     * The physical address of the entity.
     */
    @SerializedName(value = "address", alternate = {"Address"})
    @Expose
	@Nullable
    public PhysicalAddress address;

    /**
     * The Email.
     * The email of this WHOIS contact.
     */
    @SerializedName(value = "email", alternate = {"Email"})
    @Expose
	@Nullable
    public String email;

    /**
     * The Fax.
     * The fax of this WHOIS contact. No format is guaranteed.
     */
    @SerializedName(value = "fax", alternate = {"Fax"})
    @Expose
	@Nullable
    public String fax;

    /**
     * The Name.
     * The name of this WHOIS contact.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Organization.
     * The organization of this WHOIS contact.
     */
    @SerializedName(value = "organization", alternate = {"Organization"})
    @Expose
	@Nullable
    public String organization;

    /**
     * The Telephone.
     * The telephone of this WHOIS contact. No format is guaranteed.
     */
    @SerializedName(value = "telephone", alternate = {"Telephone"})
    @Expose
	@Nullable
    public String telephone;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
