// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.IpEvidence;
import com.microsoft.graph.security.models.Dictionary;
import com.microsoft.graph.security.models.KubernetesNamespaceEvidence;
import com.microsoft.graph.security.models.KubernetesServicePort;
import com.microsoft.graph.security.models.KubernetesServiceType;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Kubernetes Service Evidence.
 */
public class KubernetesServiceEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Cluster IP.
     * The service cluster IP.
     */
    @SerializedName(value = "clusterIP", alternate = {"ClusterIP"})
    @Expose
	@Nullable
    public IpEvidence clusterIP;

    /**
     * The External IPs.
     * The service external IPs.
     */
    @SerializedName(value = "externalIPs", alternate = {"ExternalIPs"})
    @Expose
	@Nullable
    public java.util.List<IpEvidence> externalIPs;

    /**
     * The Labels.
     * The service labels.
     */
    @SerializedName(value = "labels", alternate = {"Labels"})
    @Expose
	@Nullable
    public Dictionary labels;

    /**
     * The Name.
     * The service name.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Namespace.
     * The service namespace.
     */
    @SerializedName(value = "namespace", alternate = {"Namespace"})
    @Expose
	@Nullable
    public KubernetesNamespaceEvidence namespace;

    /**
     * The Selector.
     * The service selector.
     */
    @SerializedName(value = "selector", alternate = {"Selector"})
    @Expose
	@Nullable
    public Dictionary selector;

    /**
     * The Service Ports.
     * The list of service ports.
     */
    @SerializedName(value = "servicePorts", alternate = {"ServicePorts"})
    @Expose
	@Nullable
    public java.util.List<KubernetesServicePort> servicePorts;

    /**
     * The Service Type.
     * The service type. Possible values are: unknown, clusterIP, externalName, nodePort, loadBalancer, unknownFutureValue.
     */
    @SerializedName(value = "serviceType", alternate = {"ServiceType"})
    @Expose
	@Nullable
    public KubernetesServiceType serviceType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
