// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrivilegedAccessRoot;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Root Request.
 */
public class PrivilegedAccessRootRequest extends BaseRequest<PrivilegedAccessRoot> {
	
    /**
     * The request for the PrivilegedAccessRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivilegedAccessRootRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrivilegedAccessRoot.class);
    }

    /**
     * Gets the PrivilegedAccessRoot from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessRoot> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrivilegedAccessRoot from the service
     *
     * @return the PrivilegedAccessRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessRoot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessRoot> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrivilegedAccessRoot delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrivilegedAccessRoot with a source
     *
     * @param sourcePrivilegedAccessRoot the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessRoot> patchAsync(@Nonnull final PrivilegedAccessRoot sourcePrivilegedAccessRoot) {
        return sendAsync(HttpMethod.PATCH, sourcePrivilegedAccessRoot);
    }

    /**
     * Patches this PrivilegedAccessRoot with a source
     *
     * @param sourcePrivilegedAccessRoot the source object with updates
     * @return the updated PrivilegedAccessRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessRoot patch(@Nonnull final PrivilegedAccessRoot sourcePrivilegedAccessRoot) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrivilegedAccessRoot);
    }

    /**
     * Creates a PrivilegedAccessRoot with a new object
     *
     * @param newPrivilegedAccessRoot the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessRoot> postAsync(@Nonnull final PrivilegedAccessRoot newPrivilegedAccessRoot) {
        return sendAsync(HttpMethod.POST, newPrivilegedAccessRoot);
    }

    /**
     * Creates a PrivilegedAccessRoot with a new object
     *
     * @param newPrivilegedAccessRoot the new object to create
     * @return the created PrivilegedAccessRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessRoot post(@Nonnull final PrivilegedAccessRoot newPrivilegedAccessRoot) throws ClientException {
        return send(HttpMethod.POST, newPrivilegedAccessRoot);
    }

    /**
     * Creates a PrivilegedAccessRoot with a new object
     *
     * @param newPrivilegedAccessRoot the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrivilegedAccessRoot> putAsync(@Nonnull final PrivilegedAccessRoot newPrivilegedAccessRoot) {
        return sendAsync(HttpMethod.PUT, newPrivilegedAccessRoot);
    }

    /**
     * Creates a PrivilegedAccessRoot with a new object
     *
     * @param newPrivilegedAccessRoot the object to create/update
     * @return the created PrivilegedAccessRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrivilegedAccessRoot put(@Nonnull final PrivilegedAccessRoot newPrivilegedAccessRoot) throws ClientException {
        return send(HttpMethod.PUT, newPrivilegedAccessRoot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessRootRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrivilegedAccessRootRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

