// Template Source: BaseEntityCollectionReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ServicePrincipal;
import com.microsoft.graph.models.AppManagementPolicy;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.ExtensionProperty;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AppManagementPolicyWithReferenceRequest;
import com.microsoft.graph.requests.AppManagementPolicyReferenceRequestBuilder;
import com.microsoft.graph.requests.AppManagementPolicyWithReferenceRequestBuilder;
import com.microsoft.graph.requests.AppManagementPolicyCollectionWithReferencesRequest;
import com.microsoft.graph.requests.AppManagementPolicyCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.models.AppManagementPolicy;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.http.ReferenceRequestBody;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the App Management Policy Collection Reference Request.
 */
public class AppManagementPolicyCollectionReferenceRequest extends BaseCollectionWithReferencesRequest<AppManagementPolicy, AppManagementPolicyWithReferenceRequest, AppManagementPolicyReferenceRequestBuilder, AppManagementPolicyWithReferenceRequestBuilder, AppManagementPolicyCollectionResponse, AppManagementPolicyCollectionWithReferencesPage, AppManagementPolicyCollectionWithReferencesRequest> {

    /**
     * The request builder for this collection of AppManagementPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AppManagementPolicyCollectionReferenceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AppManagementPolicyCollectionResponse.class, AppManagementPolicyCollectionWithReferencesPage.class, AppManagementPolicyCollectionWithReferencesRequestBuilder.class);
    }

    /**
     * Creates a new AppManagementPolicy
     * @param newAppManagementPolicy the AppManagementPolicy to create
     * @return a future with the created object
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AppManagementPolicy> postAsync(@Nonnull final AppManagementPolicy newAppManagementPolicy) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        final ReferenceRequestBody body = new ReferenceRequestBody(getBaseRequest().getClient().getServiceRoot() + "/policies/appManagementPolicies/" + newAppManagementPolicy.id);
        return new AppManagementPolicyWithReferenceRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .postAsync(newAppManagementPolicy, body);
    }

    /**
     * Creates a new AppManagementPolicy
     * @param newAppManagementPolicy the AppManagementPolicy to create
     * @return the newly created object
     */
    @Nonnull
    public AppManagementPolicy post(@Nonnull final AppManagementPolicy newAppManagementPolicy) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        final ReferenceRequestBody body = new ReferenceRequestBody(getBaseRequest().getClient().getServiceRoot() + "/policies/appManagementPolicies/" + newAppManagementPolicy.id);
        return new AppManagementPolicyWithReferenceRequestBuilder(requestUrl,getBaseRequest().getClient(), /* Options */ null)
                .buildRequest(getBaseRequest().getHeaders())
                .post(newAppManagementPolicy, body);
    }
    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public AppManagementPolicyCollectionReferenceRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    @Nonnull
    public AppManagementPolicyCollectionReferenceRequest filter(@Nonnull final String value) {
        addFilterOption(value);
        return this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the sort clause
     * @return the updated request
     */
    @Nonnull
    public AppManagementPolicyCollectionReferenceRequest orderBy(@Nonnull final String value) {
        addOrderByOption(value);
        return this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public AppManagementPolicyCollectionReferenceRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    @Nonnull
    public AppManagementPolicyCollectionReferenceRequest top(final int value) {
        addTopOption(value);
        return this;
    }
    /**
     * Sets the count value for the request
     *
     * @param value whether or not to return the count of objects with the request
     * @return the updated request
     */
    @Nonnull
    public AppManagementPolicyCollectionReferenceRequest count(final boolean value) {
        addCountOption(value);
        return this;
    }
    /**
     * Sets the count value to true for the request
     *
     * @return the updated request
     */
    @Nonnull
    public AppManagementPolicyCollectionReferenceRequest count() {
        addCountOption(true);
        return this;
    }
}
