// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.TargetDeviceGroupCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Remote Desktop Security Configuration.
 */
public class RemoteDesktopSecurityConfiguration extends Entity implements IJsonBackedObject {


    /**
     * The Is Remote Desktop Protocol Enabled.
     * Determines if Microsoft Entra ID RDS authentication protocol for RDP is enabled.
     */
    @SerializedName(value = "isRemoteDesktopProtocolEnabled", alternate = {"IsRemoteDesktopProtocolEnabled"})
    @Expose
	@Nullable
    public Boolean isRemoteDesktopProtocolEnabled;

    /**
     * The Target Device Groups.
     * The collection of target device groups that are associated with the RDS security configuration that will be enabled for SSO when a client connects to the target device over RDP using the new Microsoft Entra ID RDS authentication protocol.
     */
    @SerializedName(value = "targetDeviceGroups", alternate = {"TargetDeviceGroups"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.TargetDeviceGroupCollectionPage targetDeviceGroups;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("targetDeviceGroups")) {
            targetDeviceGroups = serializer.deserializeObject(json.get("targetDeviceGroups"), com.microsoft.graph.requests.TargetDeviceGroupCollectionPage.class);
        }
    }
}
