// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.DomainState;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.DirectoryObjectCollectionPage;
import com.microsoft.graph.requests.InternalDomainFederationCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Domain.
 */
public class Domain extends Entity implements IJsonBackedObject {


    /**
     * The Authentication Type.
     * Indicates the configured authentication type for the domain. The value is either Managed or Federated. Managed indicates a cloud managed domain where Microsoft Entra ID performs user authentication. Federated indicates authentication is federated with an identity provider such as the tenant's on-premises Active Directory via Active Directory Federation Services. Not nullable.
     */
    @SerializedName(value = "authenticationType", alternate = {"AuthenticationType"})
    @Expose
	@Nullable
    public String authenticationType;

    /**
     * The Availability Status.
     * This property is always null except when the verify action is used. When the verify action is used, a domain entity is returned in the response. The availabilityStatus property of the domain entity in the response is either AvailableImmediately or EmailVerifiedDomainTakeoverScheduled.
     */
    @SerializedName(value = "availabilityStatus", alternate = {"AvailabilityStatus"})
    @Expose
	@Nullable
    public String availabilityStatus;

    /**
     * The Is Admin Managed.
     * The value of the property is false if the DNS record management of the domain has been delegated to Microsoft 365. Otherwise, the value is true. Not nullable
     */
    @SerializedName(value = "isAdminManaged", alternate = {"IsAdminManaged"})
    @Expose
	@Nullable
    public Boolean isAdminManaged;

    /**
     * The Is Default.
     * true if this is the default domain that is used for user creation. There is only one default domain per company. Not nullable
     */
    @SerializedName(value = "isDefault", alternate = {"IsDefault"})
    @Expose
	@Nullable
    public Boolean isDefault;

    /**
     * The Is Initial.
     * true if this is the initial domain created by Microsoft Online Services (companyname.onmicrosoft.com). There is only one initial domain per company. Not nullable
     */
    @SerializedName(value = "isInitial", alternate = {"IsInitial"})
    @Expose
	@Nullable
    public Boolean isInitial;

    /**
     * The Is Root.
     * true if the domain is a verified root domain. Otherwise, false if the domain is a subdomain or unverified. Not nullable
     */
    @SerializedName(value = "isRoot", alternate = {"IsRoot"})
    @Expose
	@Nullable
    public Boolean isRoot;

    /**
     * The Is Verified.
     * true if the domain has completed domain ownership verification. Not nullable
     */
    @SerializedName(value = "isVerified", alternate = {"IsVerified"})
    @Expose
	@Nullable
    public Boolean isVerified;

    /**
     * The Manufacturer.
     * 
     */
    @SerializedName(value = "manufacturer", alternate = {"Manufacturer"})
    @Expose
	@Nullable
    public String manufacturer;

    /**
     * The Model.
     * 
     */
    @SerializedName(value = "model", alternate = {"Model"})
    @Expose
	@Nullable
    public String model;

    /**
     * The Password Notification Window In Days.
     * Specifies the number of days before a user receives notification that their password will expire. If the property is not set, a default value of 14 days will be used.
     */
    @SerializedName(value = "passwordNotificationWindowInDays", alternate = {"PasswordNotificationWindowInDays"})
    @Expose
	@Nullable
    public Integer passwordNotificationWindowInDays;

    /**
     * The Password Validity Period In Days.
     * Specifies the length of time that a password is valid before it must be changed. If the property is not set, a default value of 90 days will be used.
     */
    @SerializedName(value = "passwordValidityPeriodInDays", alternate = {"PasswordValidityPeriodInDays"})
    @Expose
	@Nullable
    public Integer passwordValidityPeriodInDays;

    /**
     * The State.
     * Status of asynchronous operations scheduled for the domain.
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
	@Nullable
    public DomainState state;

    /**
     * The Supported Services.
     * The capabilities assigned to the domain. Can include 0, 1 or more of following values: Email, Sharepoint, EmailInternalRelayOnly, OfficeCommunicationsOnline, SharePointDefaultDomain, FullRedelegation, SharePointPublic, OrgIdAuthentication, Yammer, Intune. The values which you can add/remove using Graph API include: Email, OfficeCommunicationsOnline, Yammer. Not nullable.
     */
    @SerializedName(value = "supportedServices", alternate = {"SupportedServices"})
    @Expose
	@Nullable
    public java.util.List<String> supportedServices;

    /**
     * The Domain Name References.
     * The objects such as users and groups that reference the domain ID. Read-only, Nullable. Supports $expand and $filter by the OData type of objects returned. For example /domains/{domainId}/domainNameReferences/microsoft.graph.user and /domains/{domainId}/domainNameReferences/microsoft.graph.group.
     */
	@Nullable
    public com.microsoft.graph.requests.DirectoryObjectCollectionPage domainNameReferences;

    /**
     * The Federation Configuration.
     * Domain settings configured by a customer when federated with Microsoft Entra ID. Supports $expand.
     */
    @SerializedName(value = "federationConfiguration", alternate = {"FederationConfiguration"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.InternalDomainFederationCollectionPage federationConfiguration;

    /**
     * The Service Configuration Records.
     * DNS records the customer adds to the DNS zone file of the domain before the domain can be used by Microsoft Online services. Read-only, Nullable. Supports $expand.
     */
    @SerializedName(value = "serviceConfigurationRecords", alternate = {"ServiceConfigurationRecords"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.DomainDnsRecordCollectionPage serviceConfigurationRecords;

    /**
     * The Verification Dns Records.
     * DNS records that the customer adds to the DNS zone file of the domain before the customer can complete domain ownership verification with Microsoft Entra ID. Read-only, Nullable. Supports $expand.
     */
    @SerializedName(value = "verificationDnsRecords", alternate = {"VerificationDnsRecords"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.DomainDnsRecordCollectionPage verificationDnsRecords;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("domainNameReferences")) {
            domainNameReferences = serializer.deserializeObject(json.get("domainNameReferences"), com.microsoft.graph.requests.DirectoryObjectCollectionPage.class);
        }

        if (json.has("federationConfiguration")) {
            federationConfiguration = serializer.deserializeObject(json.get("federationConfiguration"), com.microsoft.graph.requests.InternalDomainFederationCollectionPage.class);
        }

        if (json.has("serviceConfigurationRecords")) {
            serviceConfigurationRecords = serializer.deserializeObject(json.get("serviceConfigurationRecords"), com.microsoft.graph.requests.DomainDnsRecordCollectionPage.class);
        }

        if (json.has("verificationDnsRecords")) {
            verificationDnsRecords = serializer.deserializeObject(json.get("verificationDnsRecords"), com.microsoft.graph.requests.DomainDnsRecordCollectionPage.class);
        }
    }
}
