// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.WhoisHistoryRecord;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Whois History Record Request.
 */
public class WhoisHistoryRecordRequest extends BaseRequest<WhoisHistoryRecord> {
	
    /**
     * The request for the WhoisHistoryRecord
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WhoisHistoryRecordRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WhoisHistoryRecord.class);
    }

    /**
     * Gets the WhoisHistoryRecord from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WhoisHistoryRecord> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WhoisHistoryRecord from the service
     *
     * @return the WhoisHistoryRecord from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WhoisHistoryRecord get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WhoisHistoryRecord> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WhoisHistoryRecord delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WhoisHistoryRecord with a source
     *
     * @param sourceWhoisHistoryRecord the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WhoisHistoryRecord> patchAsync(@Nonnull final WhoisHistoryRecord sourceWhoisHistoryRecord) {
        return sendAsync(HttpMethod.PATCH, sourceWhoisHistoryRecord);
    }

    /**
     * Patches this WhoisHistoryRecord with a source
     *
     * @param sourceWhoisHistoryRecord the source object with updates
     * @return the updated WhoisHistoryRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WhoisHistoryRecord patch(@Nonnull final WhoisHistoryRecord sourceWhoisHistoryRecord) throws ClientException {
        return send(HttpMethod.PATCH, sourceWhoisHistoryRecord);
    }

    /**
     * Creates a WhoisHistoryRecord with a new object
     *
     * @param newWhoisHistoryRecord the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WhoisHistoryRecord> postAsync(@Nonnull final WhoisHistoryRecord newWhoisHistoryRecord) {
        return sendAsync(HttpMethod.POST, newWhoisHistoryRecord);
    }

    /**
     * Creates a WhoisHistoryRecord with a new object
     *
     * @param newWhoisHistoryRecord the new object to create
     * @return the created WhoisHistoryRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WhoisHistoryRecord post(@Nonnull final WhoisHistoryRecord newWhoisHistoryRecord) throws ClientException {
        return send(HttpMethod.POST, newWhoisHistoryRecord);
    }

    /**
     * Creates a WhoisHistoryRecord with a new object
     *
     * @param newWhoisHistoryRecord the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WhoisHistoryRecord> putAsync(@Nonnull final WhoisHistoryRecord newWhoisHistoryRecord) {
        return sendAsync(HttpMethod.PUT, newWhoisHistoryRecord);
    }

    /**
     * Creates a WhoisHistoryRecord with a new object
     *
     * @param newWhoisHistoryRecord the object to create/update
     * @return the created WhoisHistoryRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WhoisHistoryRecord put(@Nonnull final WhoisHistoryRecord newWhoisHistoryRecord) throws ClientException {
        return send(HttpMethod.PUT, newWhoisHistoryRecord);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WhoisHistoryRecordRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WhoisHistoryRecordRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

