// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.HostTracker;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Tracker Request.
 */
public class HostTrackerRequest extends BaseRequest<HostTracker> {
	
    /**
     * The request for the HostTracker
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public HostTrackerRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostTracker.class);
    }

    /**
     * Gets the HostTracker from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostTracker> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the HostTracker from the service
     *
     * @return the HostTracker from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostTracker get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostTracker> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public HostTracker delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this HostTracker with a source
     *
     * @param sourceHostTracker the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostTracker> patchAsync(@Nonnull final HostTracker sourceHostTracker) {
        return sendAsync(HttpMethod.PATCH, sourceHostTracker);
    }

    /**
     * Patches this HostTracker with a source
     *
     * @param sourceHostTracker the source object with updates
     * @return the updated HostTracker
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostTracker patch(@Nonnull final HostTracker sourceHostTracker) throws ClientException {
        return send(HttpMethod.PATCH, sourceHostTracker);
    }

    /**
     * Creates a HostTracker with a new object
     *
     * @param newHostTracker the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostTracker> postAsync(@Nonnull final HostTracker newHostTracker) {
        return sendAsync(HttpMethod.POST, newHostTracker);
    }

    /**
     * Creates a HostTracker with a new object
     *
     * @param newHostTracker the new object to create
     * @return the created HostTracker
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostTracker post(@Nonnull final HostTracker newHostTracker) throws ClientException {
        return send(HttpMethod.POST, newHostTracker);
    }

    /**
     * Creates a HostTracker with a new object
     *
     * @param newHostTracker the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostTracker> putAsync(@Nonnull final HostTracker newHostTracker) {
        return sendAsync(HttpMethod.PUT, newHostTracker);
    }

    /**
     * Creates a HostTracker with a new object
     *
     * @param newHostTracker the object to create/update
     * @return the created HostTracker
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostTracker put(@Nonnull final HostTracker newHostTracker) throws ClientException {
        return send(HttpMethod.PUT, newHostTracker);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public HostTrackerRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public HostTrackerRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

