// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageAssignmentRequestWorkflowExtension;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment Request Workflow Extension Request.
 */
public class AccessPackageAssignmentRequestWorkflowExtensionRequest extends BaseRequest<AccessPackageAssignmentRequestWorkflowExtension> {
	
    /**
     * The request for the AccessPackageAssignmentRequestWorkflowExtension
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageAssignmentRequestWorkflowExtensionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageAssignmentRequestWorkflowExtension.class);
    }

    /**
     * Gets the AccessPackageAssignmentRequestWorkflowExtension from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentRequestWorkflowExtension> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessPackageAssignmentRequestWorkflowExtension from the service
     *
     * @return the AccessPackageAssignmentRequestWorkflowExtension from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentRequestWorkflowExtension get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentRequestWorkflowExtension> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessPackageAssignmentRequestWorkflowExtension delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessPackageAssignmentRequestWorkflowExtension with a source
     *
     * @param sourceAccessPackageAssignmentRequestWorkflowExtension the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentRequestWorkflowExtension> patchAsync(@Nonnull final AccessPackageAssignmentRequestWorkflowExtension sourceAccessPackageAssignmentRequestWorkflowExtension) {
        return sendAsync(HttpMethod.PATCH, sourceAccessPackageAssignmentRequestWorkflowExtension);
    }

    /**
     * Patches this AccessPackageAssignmentRequestWorkflowExtension with a source
     *
     * @param sourceAccessPackageAssignmentRequestWorkflowExtension the source object with updates
     * @return the updated AccessPackageAssignmentRequestWorkflowExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentRequestWorkflowExtension patch(@Nonnull final AccessPackageAssignmentRequestWorkflowExtension sourceAccessPackageAssignmentRequestWorkflowExtension) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessPackageAssignmentRequestWorkflowExtension);
    }

    /**
     * Creates a AccessPackageAssignmentRequestWorkflowExtension with a new object
     *
     * @param newAccessPackageAssignmentRequestWorkflowExtension the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentRequestWorkflowExtension> postAsync(@Nonnull final AccessPackageAssignmentRequestWorkflowExtension newAccessPackageAssignmentRequestWorkflowExtension) {
        return sendAsync(HttpMethod.POST, newAccessPackageAssignmentRequestWorkflowExtension);
    }

    /**
     * Creates a AccessPackageAssignmentRequestWorkflowExtension with a new object
     *
     * @param newAccessPackageAssignmentRequestWorkflowExtension the new object to create
     * @return the created AccessPackageAssignmentRequestWorkflowExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentRequestWorkflowExtension post(@Nonnull final AccessPackageAssignmentRequestWorkflowExtension newAccessPackageAssignmentRequestWorkflowExtension) throws ClientException {
        return send(HttpMethod.POST, newAccessPackageAssignmentRequestWorkflowExtension);
    }

    /**
     * Creates a AccessPackageAssignmentRequestWorkflowExtension with a new object
     *
     * @param newAccessPackageAssignmentRequestWorkflowExtension the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentRequestWorkflowExtension> putAsync(@Nonnull final AccessPackageAssignmentRequestWorkflowExtension newAccessPackageAssignmentRequestWorkflowExtension) {
        return sendAsync(HttpMethod.PUT, newAccessPackageAssignmentRequestWorkflowExtension);
    }

    /**
     * Creates a AccessPackageAssignmentRequestWorkflowExtension with a new object
     *
     * @param newAccessPackageAssignmentRequestWorkflowExtension the object to create/update
     * @return the created AccessPackageAssignmentRequestWorkflowExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentRequestWorkflowExtension put(@Nonnull final AccessPackageAssignmentRequestWorkflowExtension newAccessPackageAssignmentRequestWorkflowExtension) throws ClientException {
        return send(HttpMethod.PUT, newAccessPackageAssignmentRequestWorkflowExtension);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageAssignmentRequestWorkflowExtensionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageAssignmentRequestWorkflowExtensionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

