// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.UserSimulationEventInfo;
import com.microsoft.graph.models.AttackSimulationUser;
import com.microsoft.graph.models.UserTrainingEventInfo;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Simulation Details.
 */
public class UserSimulationDetails implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Assigned Trainings Count.
     * Number of trainings assigned to a user in an attack simulation and training campaign.
     */
    @SerializedName(value = "assignedTrainingsCount", alternate = {"AssignedTrainingsCount"})
    @Expose
	@Nullable
    public Integer assignedTrainingsCount;

    /**
     * The Completed Trainings Count.
     * Number of trainings completed by a user in an attack simulation and training campaign.
     */
    @SerializedName(value = "completedTrainingsCount", alternate = {"CompletedTrainingsCount"})
    @Expose
	@Nullable
    public Integer completedTrainingsCount;

    /**
     * The Compromised Date Time.
     * Date and time of the compromising online action by a user in an attack simulation and training campaign.
     */
    @SerializedName(value = "compromisedDateTime", alternate = {"CompromisedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime compromisedDateTime;

    /**
     * The In Progress Trainings Count.
     * Number of trainings in progress by a user in an attack simulation and training campaign.
     */
    @SerializedName(value = "inProgressTrainingsCount", alternate = {"InProgressTrainingsCount"})
    @Expose
	@Nullable
    public Integer inProgressTrainingsCount;

    /**
     * The Is Compromised.
     * Indicates whether a user was compromised in an attack simulation and training campaign.
     */
    @SerializedName(value = "isCompromised", alternate = {"IsCompromised"})
    @Expose
	@Nullable
    public Boolean isCompromised;

    /**
     * The Reported Phish Date Time.
     * Date and time when a user reported the delivered payload as phishing in the attack simulation and training campaign.
     */
    @SerializedName(value = "reportedPhishDateTime", alternate = {"ReportedPhishDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime reportedPhishDateTime;

    /**
     * The Simulation Events.
     * List of simulation events of a user in the attack simulation and training campaign.
     */
    @SerializedName(value = "simulationEvents", alternate = {"SimulationEvents"})
    @Expose
	@Nullable
    public java.util.List<UserSimulationEventInfo> simulationEvents;

    /**
     * The Simulation User.
     * User in an attack simulation and training campaign.
     */
    @SerializedName(value = "simulationUser", alternate = {"SimulationUser"})
    @Expose
	@Nullable
    public AttackSimulationUser simulationUser;

    /**
     * The Training Events.
     * List of training events of a user in the attack simulation and training campaign.
     */
    @SerializedName(value = "trainingEvents", alternate = {"TrainingEvents"})
    @Expose
	@Nullable
    public java.util.List<UserTrainingEventInfo> trainingEvents;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
