// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.PayloadBrand;
import com.microsoft.graph.models.PayloadComplexity;
import com.microsoft.graph.models.EmailIdentity;
import com.microsoft.graph.models.PayloadDetail;
import com.microsoft.graph.models.PayloadIndustry;
import com.microsoft.graph.models.PayloadDeliveryPlatform;
import com.microsoft.graph.models.SimulationAttackType;
import com.microsoft.graph.models.SimulationContentSource;
import com.microsoft.graph.models.SimulationContentStatus;
import com.microsoft.graph.models.SimulationAttackTechnique;
import com.microsoft.graph.models.PayloadTheme;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Payload.
 */
public class Payload extends Entity implements IJsonBackedObject {


    /**
     * The Brand.
     * 
     */
    @SerializedName(value = "brand", alternate = {"Brand"})
    @Expose
	@Nullable
    public PayloadBrand brand;

    /**
     * The Complexity.
     * 
     */
    @SerializedName(value = "complexity", alternate = {"Complexity"})
    @Expose
	@Nullable
    public PayloadComplexity complexity;

    /**
     * The Created By.
     * 
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public EmailIdentity createdBy;

    /**
     * The Created Date Time.
     * 
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * 
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Detail.
     * 
     */
    @SerializedName(value = "detail", alternate = {"Detail"})
    @Expose
	@Nullable
    public PayloadDetail detail;

    /**
     * The Display Name.
     * 
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Industry.
     * 
     */
    @SerializedName(value = "industry", alternate = {"Industry"})
    @Expose
	@Nullable
    public PayloadIndustry industry;

    /**
     * The Is Automated.
     * 
     */
    @SerializedName(value = "isAutomated", alternate = {"IsAutomated"})
    @Expose
	@Nullable
    public Boolean isAutomated;

    /**
     * The Is Controversial.
     * 
     */
    @SerializedName(value = "isControversial", alternate = {"IsControversial"})
    @Expose
	@Nullable
    public Boolean isControversial;

    /**
     * The Is Current Event.
     * 
     */
    @SerializedName(value = "isCurrentEvent", alternate = {"IsCurrentEvent"})
    @Expose
	@Nullable
    public Boolean isCurrentEvent;

    /**
     * The Language.
     * 
     */
    @SerializedName(value = "language", alternate = {"Language"})
    @Expose
	@Nullable
    public String language;

    /**
     * The Last Modified By.
     * 
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public EmailIdentity lastModifiedBy;

    /**
     * The Last Modified Date Time.
     * 
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Payload Tags.
     * 
     */
    @SerializedName(value = "payloadTags", alternate = {"PayloadTags"})
    @Expose
	@Nullable
    public java.util.List<String> payloadTags;

    /**
     * The Platform.
     * 
     */
    @SerializedName(value = "platform", alternate = {"Platform"})
    @Expose
	@Nullable
    public PayloadDeliveryPlatform platform;

    /**
     * The Predicted Compromise Rate.
     * 
     */
    @SerializedName(value = "predictedCompromiseRate", alternate = {"PredictedCompromiseRate"})
    @Expose
	@Nullable
    public Double predictedCompromiseRate;

    /**
     * The Simulation Attack Type.
     * 
     */
    @SerializedName(value = "simulationAttackType", alternate = {"SimulationAttackType"})
    @Expose
	@Nullable
    public SimulationAttackType simulationAttackType;

    /**
     * The Source.
     * 
     */
    @SerializedName(value = "source", alternate = {"Source"})
    @Expose
	@Nullable
    public SimulationContentSource source;

    /**
     * The Status.
     * 
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public SimulationContentStatus status;

    /**
     * The Technique.
     * 
     */
    @SerializedName(value = "technique", alternate = {"Technique"})
    @Expose
	@Nullable
    public SimulationAttackTechnique technique;

    /**
     * The Theme.
     * 
     */
    @SerializedName(value = "theme", alternate = {"Theme"})
    @Expose
	@Nullable
    public PayloadTheme theme;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
