/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.HostSslCertificate;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostSslCertificateReferenceRequest
extends BaseReferenceRequest<HostSslCertificate> {
    public HostSslCertificateReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostSslCertificate.class);
    }

    @Nonnull
    public HostSslCertificateReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostSslCertificateReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<HostSslCertificate> putAsync(@Nonnull HostSslCertificate srcHostSslCertificate) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/host/{id}/sslCertificates/" + srcHostSslCertificate.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public HostSslCertificate put(@Nonnull HostSslCertificate srcHostSslCertificate) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/host/{id}/sslCertificates/" + srcHostSslCertificate.id));
        return (HostSslCertificate)this.send(HttpMethod.PUT, payload);
    }
}

