/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.DirectoryDefinition;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DirectoryDefinitionCollectionPage;
import com.microsoft.graph.requests.DirectoryDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.DirectoryDefinitionCollectionResponse;
import com.microsoft.graph.requests.DirectoryDefinitionRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DirectoryDefinitionCollectionRequest
extends BaseEntityCollectionRequest<DirectoryDefinition, DirectoryDefinitionCollectionResponse, DirectoryDefinitionCollectionPage> {
    public DirectoryDefinitionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryDefinitionCollectionResponse.class, DirectoryDefinitionCollectionPage.class, DirectoryDefinitionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<DirectoryDefinition> postAsync(@Nonnull DirectoryDefinition newDirectoryDefinition) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DirectoryDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newDirectoryDefinition);
    }

    @Nonnull
    public DirectoryDefinition post(@Nonnull DirectoryDefinition newDirectoryDefinition) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DirectoryDefinitionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDirectoryDefinition);
    }

    @Nonnull
    public DirectoryDefinitionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public DirectoryDefinitionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public DirectoryDefinitionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public DirectoryDefinitionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DirectoryDefinitionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public DirectoryDefinitionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public DirectoryDefinitionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public DirectoryDefinitionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public DirectoryDefinitionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

