/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Organization;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OrganizationRequest
extends BaseRequest<Organization> {
    public OrganizationRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Organization.class);
    }

    @Nonnull
    public CompletableFuture<Organization> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Organization get() throws ClientException {
        return (Organization)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Organization> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Organization delete() throws ClientException {
        return (Organization)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Organization> patchAsync(@Nonnull Organization sourceOrganization) {
        return this.sendAsync(HttpMethod.PATCH, sourceOrganization);
    }

    @Nullable
    public Organization patch(@Nonnull Organization sourceOrganization) throws ClientException {
        return (Organization)this.send(HttpMethod.PATCH, sourceOrganization);
    }

    @Nonnull
    public CompletableFuture<Organization> postAsync(@Nonnull Organization newOrganization) {
        return this.sendAsync(HttpMethod.POST, newOrganization);
    }

    @Nullable
    public Organization post(@Nonnull Organization newOrganization) throws ClientException {
        return (Organization)this.send(HttpMethod.POST, newOrganization);
    }

    @Nonnull
    public CompletableFuture<Organization> putAsync(@Nonnull Organization newOrganization) {
        return this.sendAsync(HttpMethod.PUT, newOrganization);
    }

    @Nullable
    public Organization put(@Nonnull Organization newOrganization) throws ClientException {
        return (Organization)this.send(HttpMethod.PUT, newOrganization);
    }

    @Nonnull
    public OrganizationRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public OrganizationRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

