// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.ExportFileMetadata;
import com.microsoft.graph.security.models.ExportOptions;
import com.microsoft.graph.security.models.ExportFileStructure;
import com.microsoft.graph.security.models.EdiscoveryReviewSet;
import com.microsoft.graph.security.models.EdiscoveryReviewSetQuery;
import com.microsoft.graph.security.models.CaseOperation;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Export Operation.
 */
public class EdiscoveryExportOperation extends CaseOperation implements IJsonBackedObject {


    /**
     * The Description.
     * The description provided for the export.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Export File Metadata.
     * 
     */
    @SerializedName(value = "exportFileMetadata", alternate = {"ExportFileMetadata"})
    @Expose
	@Nullable
    public java.util.List<ExportFileMetadata> exportFileMetadata;

    /**
     * The Export Options.
     * The options provided for the export. For more details, see reviewSet: export. Possible values are: originalFiles, text, pdfReplacement,  tags.
     */
    @SerializedName(value = "exportOptions", alternate = {"ExportOptions"})
    @Expose
	@Nullable
    public EnumSet<ExportOptions> exportOptions;

    /**
     * The Export Structure.
     * The options provided that specify the structure of the export. For more details, see reviewSet: export. Possible values are: none, directory, pst.
     */
    @SerializedName(value = "exportStructure", alternate = {"ExportStructure"})
    @Expose
	@Nullable
    public ExportFileStructure exportStructure;

    /**
     * The Output Name.
     * The name provided for the export.
     */
    @SerializedName(value = "outputName", alternate = {"OutputName"})
    @Expose
	@Nullable
    public String outputName;

    /**
     * The Review Set.
     * Review set from where documents are exported.
     */
    @SerializedName(value = "reviewSet", alternate = {"ReviewSet"})
    @Expose
	@Nullable
    public EdiscoveryReviewSet reviewSet;

    /**
     * The Review Set Query.
     * The review set query which is used to filter the documents for export.
     */
    @SerializedName(value = "reviewSetQuery", alternate = {"ReviewSetQuery"})
    @Expose
	@Nullable
    public EdiscoveryReviewSetQuery reviewSetQuery;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
