// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MobileAppTroubleshootingEvent;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile App Troubleshooting Event Request.
 */
public class MobileAppTroubleshootingEventRequest extends BaseRequest<MobileAppTroubleshootingEvent> {
	
    /**
     * The request for the MobileAppTroubleshootingEvent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MobileAppTroubleshootingEventRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppTroubleshootingEvent.class);
    }

    /**
     * Gets the MobileAppTroubleshootingEvent from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileAppTroubleshootingEvent> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MobileAppTroubleshootingEvent from the service
     *
     * @return the MobileAppTroubleshootingEvent from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileAppTroubleshootingEvent get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileAppTroubleshootingEvent> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MobileAppTroubleshootingEvent delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MobileAppTroubleshootingEvent with a source
     *
     * @param sourceMobileAppTroubleshootingEvent the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileAppTroubleshootingEvent> patchAsync(@Nonnull final MobileAppTroubleshootingEvent sourceMobileAppTroubleshootingEvent) {
        return sendAsync(HttpMethod.PATCH, sourceMobileAppTroubleshootingEvent);
    }

    /**
     * Patches this MobileAppTroubleshootingEvent with a source
     *
     * @param sourceMobileAppTroubleshootingEvent the source object with updates
     * @return the updated MobileAppTroubleshootingEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileAppTroubleshootingEvent patch(@Nonnull final MobileAppTroubleshootingEvent sourceMobileAppTroubleshootingEvent) throws ClientException {
        return send(HttpMethod.PATCH, sourceMobileAppTroubleshootingEvent);
    }

    /**
     * Creates a MobileAppTroubleshootingEvent with a new object
     *
     * @param newMobileAppTroubleshootingEvent the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileAppTroubleshootingEvent> postAsync(@Nonnull final MobileAppTroubleshootingEvent newMobileAppTroubleshootingEvent) {
        return sendAsync(HttpMethod.POST, newMobileAppTroubleshootingEvent);
    }

    /**
     * Creates a MobileAppTroubleshootingEvent with a new object
     *
     * @param newMobileAppTroubleshootingEvent the new object to create
     * @return the created MobileAppTroubleshootingEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileAppTroubleshootingEvent post(@Nonnull final MobileAppTroubleshootingEvent newMobileAppTroubleshootingEvent) throws ClientException {
        return send(HttpMethod.POST, newMobileAppTroubleshootingEvent);
    }

    /**
     * Creates a MobileAppTroubleshootingEvent with a new object
     *
     * @param newMobileAppTroubleshootingEvent the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileAppTroubleshootingEvent> putAsync(@Nonnull final MobileAppTroubleshootingEvent newMobileAppTroubleshootingEvent) {
        return sendAsync(HttpMethod.PUT, newMobileAppTroubleshootingEvent);
    }

    /**
     * Creates a MobileAppTroubleshootingEvent with a new object
     *
     * @param newMobileAppTroubleshootingEvent the object to create/update
     * @return the created MobileAppTroubleshootingEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileAppTroubleshootingEvent put(@Nonnull final MobileAppTroubleshootingEvent newMobileAppTroubleshootingEvent) throws ClientException {
        return send(HttpMethod.PUT, newMobileAppTroubleshootingEvent);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MobileAppTroubleshootingEventRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MobileAppTroubleshootingEventRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

