// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Hlookup Parameter Set.
 */
public class WorkbookFunctionsHlookupParameterSet {
    /**
     * The lookup Value.
     * 
     */
    @SerializedName(value = "lookupValue", alternate = {"LookupValue"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement lookupValue;

    /**
     * The table Array.
     * 
     */
    @SerializedName(value = "tableArray", alternate = {"TableArray"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement tableArray;

    /**
     * The row Index Num.
     * 
     */
    @SerializedName(value = "rowIndexNum", alternate = {"RowIndexNum"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement rowIndexNum;

    /**
     * The range Lookup.
     * 
     */
    @SerializedName(value = "rangeLookup", alternate = {"RangeLookup"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement rangeLookup;


    /**
     * Instiaciates a new WorkbookFunctionsHlookupParameterSet
     */
    public WorkbookFunctionsHlookupParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsHlookupParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsHlookupParameterSet(@Nonnull final WorkbookFunctionsHlookupParameterSetBuilder builder) {
        this.lookupValue = builder.lookupValue;
        this.tableArray = builder.tableArray;
        this.rowIndexNum = builder.rowIndexNum;
        this.rangeLookup = builder.rangeLookup;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsHlookupParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsHlookupParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsHlookupParameterSet
     */
    public static final class WorkbookFunctionsHlookupParameterSetBuilder {
        /**
         * The lookupValue parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement lookupValue;
        /**
         * Sets the LookupValue
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsHlookupParameterSetBuilder withLookupValue(@Nullable final com.google.gson.JsonElement val) {
            this.lookupValue = val;
            return this;
        }
        /**
         * The tableArray parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement tableArray;
        /**
         * Sets the TableArray
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsHlookupParameterSetBuilder withTableArray(@Nullable final com.google.gson.JsonElement val) {
            this.tableArray = val;
            return this;
        }
        /**
         * The rowIndexNum parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement rowIndexNum;
        /**
         * Sets the RowIndexNum
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsHlookupParameterSetBuilder withRowIndexNum(@Nullable final com.google.gson.JsonElement val) {
            this.rowIndexNum = val;
            return this;
        }
        /**
         * The rangeLookup parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement rangeLookup;
        /**
         * Sets the RangeLookup
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsHlookupParameterSetBuilder withRangeLookup(@Nullable final com.google.gson.JsonElement val) {
            this.rangeLookup = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsHlookupParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsHlookupParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsHlookupParameterSet build() {
            return new WorkbookFunctionsHlookupParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.lookupValue != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("lookupValue", lookupValue));
        }
        if(this.tableArray != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("tableArray", tableArray));
        }
        if(this.rowIndexNum != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("rowIndexNum", rowIndexNum));
        }
        if(this.rangeLookup != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("rangeLookup", rangeLookup));
        }
        return result;
    }
}
